/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.BaseClientDetails;
import org.springframework.security.oauth2.provider.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.InMemoryClientDetailsService;
import org.springframework.security.oauth2.provider.approval.Approval;
import org.springframework.security.oauth2.provider.approval.ApprovalStoreUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.InMemoryApprovalStore;

public class TestApprovalStoreUserApprovalHandler {
    private ApprovalStoreUserApprovalHandler handler = new ApprovalStoreUserApprovalHandler();
    private InMemoryApprovalStore store = new InMemoryApprovalStore();
    private InMemoryClientDetailsService clientDetailsService = new InMemoryClientDetailsService();
    private Authentication userAuthentication;

    @Before
    public void init() {
        this.handler.setApprovalStore(this.store);
        InMemoryClientDetailsService clientDetailsService = new InMemoryClientDetailsService();
        HashMap<String, BaseClientDetails> map = new HashMap<String, BaseClientDetails>();
        map.put("client", new BaseClientDetails("client", null, "read,write", "authorization_code", null));
        clientDetailsService.setClientDetailsStore(map);
        this.handler.setRequestFactory(new DefaultOAuth2RequestFactory(clientDetailsService));
        this.userAuthentication = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"N/A", (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"USER"));
    }

    @Test
    public void testExplicitlyApprovedScopes() {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        authorizationRequest.setApprovalParameters(Collections.singletonMap("scope.read", "approved"));
        AuthorizationRequest result = this.handler.updateAfterApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)this.handler.isApproved(result, this.userAuthentication));
        Assert.assertEquals((long)1L, (long)this.store.getApprovals("user", "client").size());
        Assert.assertEquals((long)1L, (long)result.getScope().size());
        Assert.assertTrue((boolean)result.isApproved());
    }

    @Test
    public void testImplicitlyDeniedScope() {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read", "write"));
        authorizationRequest.setApprovalParameters(Collections.singletonMap("scope.read", "approved"));
        AuthorizationRequest result = this.handler.updateAfterApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)this.handler.isApproved(result, this.userAuthentication));
        Collection<Approval> approvals = this.store.getApprovals("user", "client");
        Assert.assertEquals((long)2L, (long)approvals.size());
        approvals.contains(new Approval("user", "client", "read", new Date(), Approval.ApprovalStatus.APPROVED));
        approvals.contains(new Approval("user", "client", "write", new Date(), Approval.ApprovalStatus.DENIED));
        Assert.assertEquals((long)1L, (long)result.getScope().size());
    }

    @Test
    public void testExplicitlyPreapprovedScopes() {
        this.store.addApprovals(Arrays.asList(new Approval("user", "client", "read", new Date(System.currentTimeMillis() + 10000L), Approval.ApprovalStatus.APPROVED)));
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        AuthorizationRequest result = this.handler.checkForPreApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)result.isApproved());
    }

    @Test
    public void testAutoapprovedScopes() {
        this.handler.setClientDetailsService(this.clientDetailsService);
        BaseClientDetails client = new BaseClientDetails("client", null, "read", "authorization_code", null);
        client.setAutoApproveScopes(new HashSet<String>(Arrays.asList("read")));
        this.clientDetailsService.setClientDetailsStore(Collections.singletonMap("client", client));
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        AuthorizationRequest result = this.handler.checkForPreApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)result.isApproved());
    }

    @Test
    public void testAutoapprovedWildcardScopes() {
        this.handler.setClientDetailsService(this.clientDetailsService);
        BaseClientDetails client = new BaseClientDetails("client", null, "read", "authorization_code", null);
        client.setAutoApproveScopes(new HashSet<String>(Arrays.asList(".*")));
        this.clientDetailsService.setClientDetailsStore(Collections.singletonMap("client", client));
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        AuthorizationRequest result = this.handler.checkForPreApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)result.isApproved());
    }

    @Test
    public void testAutoapprovedAllScopes() {
        this.handler.setClientDetailsService(this.clientDetailsService);
        BaseClientDetails client = new BaseClientDetails("client", null, "read", "authorization_code", null);
        client.setAutoApproveScopes(new HashSet<String>(Arrays.asList("true")));
        this.clientDetailsService.setClientDetailsStore(Collections.singletonMap("client", client));
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        AuthorizationRequest result = this.handler.checkForPreApproval(authorizationRequest, this.userAuthentication);
        Assert.assertTrue((boolean)result.isApproved());
    }

    @Test
    public void testExpiredPreapprovedScopes() {
        this.store.addApprovals(Arrays.asList(new Approval("user", "client", "read", new Date(System.currentTimeMillis() - 10000L), Approval.ApprovalStatus.APPROVED)));
        AuthorizationRequest authorizationRequest = new AuthorizationRequest("client", Arrays.asList("read"));
        AuthorizationRequest result = this.handler.checkForPreApproval(authorizationRequest, this.userAuthentication);
        Assert.assertFalse((boolean)result.isApproved());
    }
}

