/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationRequest
implements AuthorizationRequest,
Serializable {
    private Set<String> scope = new LinkedHashSet<String>();
    private Set<String> resourceIds = new HashSet<String>();
    private boolean approved = false;
    private Collection<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private Map<String, String> authorizationParameters = new ConcurrentHashMap<String, String>();
    private Map<String, String> approvalParameters = new HashMap<String, String>();
    private String resolvedRedirectUri;

    public DefaultAuthorizationRequest(Map<String, String> authorizationParameters) {
        this(authorizationParameters, Collections.emptyMap(), authorizationParameters.get("client_id"), OAuth2Utils.parseParameterList(authorizationParameters.get("scope")), null, null, false);
    }

    public DefaultAuthorizationRequest(Map<String, String> authorizationParameters, Map<String, String> approvalParameters, String clientId, Collection<String> scope) {
        this(authorizationParameters, approvalParameters, clientId, scope, null, null, false);
    }

    public DefaultAuthorizationRequest(String clientId, Collection<String> scope) {
        this(null, null, clientId, scope, null, null, false);
    }

    public DefaultAuthorizationRequest(AuthorizationRequest copy) {
        this(copy.getAuthorizationParameters(), copy.getApprovalParameters(), copy.getClientId(), copy.getScope(), copy.getAuthorities(), copy.getResourceIds(), copy.isApproved());
        this.setRedirectUri(copy.getRedirectUri());
        if (!this.scope.isEmpty()) {
            this.authorizationParameters.put("scope", OAuth2Utils.formatParameterList(this.scope));
        }
    }

    private DefaultAuthorizationRequest(Map<String, String> authorizationParameters, Map<String, String> approvalParameters, String clientId, Collection<String> scope, Collection<GrantedAuthority> authorities, Collection<String> resourceIds, boolean approved) {
        String scopes;
        if (authorizationParameters != null) {
            this.authorizationParameters.putAll(authorizationParameters);
        }
        if (approvalParameters != null) {
            this.approvalParameters.putAll(approvalParameters);
        }
        if (resourceIds != null) {
            this.resourceIds = new HashSet<String>(resourceIds);
        }
        if (scope != null) {
            this.scope = new LinkedHashSet<String>(scope);
        }
        if (authorities != null) {
            this.authorities = new HashSet<GrantedAuthority>(authorities);
        }
        if (clientId != null) {
            this.authorizationParameters.put("client_id", clientId);
        }
        if ((scopes = OAuth2Utils.formatParameterList(scope)) != null) {
            this.authorizationParameters.put("scope", scopes);
        }
        this.approved = approved;
    }

    @Override
    public Map<String, String> getAuthorizationParameters() {
        return Collections.unmodifiableMap(this.authorizationParameters);
    }

    @Override
    public Map<String, String> getApprovalParameters() {
        return Collections.unmodifiableMap(this.approvalParameters);
    }

    @Override
    public String getClientId() {
        return this.authorizationParameters.get("client_id");
    }

    @Override
    public Set<String> getScope() {
        return Collections.unmodifiableSet(this.scope);
    }

    @Override
    public Set<String> getResourceIds() {
        return Collections.unmodifiableSet(this.resourceIds);
    }

    @Override
    public Collection<GrantedAuthority> getAuthorities() {
        return Collections.unmodifiableSet((Set)this.authorities);
    }

    @Override
    public boolean isApproved() {
        return this.approved;
    }

    @Override
    public boolean isDenied() {
        return !this.approved;
    }

    @Override
    public String getState() {
        return this.authorizationParameters.get("state");
    }

    @Override
    public String getRedirectUri() {
        return this.resolvedRedirectUri == null ? this.authorizationParameters.get("redirect_uri") : this.resolvedRedirectUri;
    }

    @Override
    public Set<String> getResponseTypes() {
        return OAuth2Utils.parseParameterList(this.authorizationParameters.get("response_type"));
    }

    public void setRedirectUri(String redirectUri) {
        this.resolvedRedirectUri = redirectUri;
    }

    public void addClientDetails(ClientDetails clientDetails) {
        this.resourceIds.addAll(clientDetails.getResourceIds());
        this.authorities.addAll(clientDetails.getAuthorities());
    }

    public void setScope(Set<String> scope) {
        String value;
        if (scope != null && scope.size() == 1 && ((value = scope.iterator().next()).contains(" ") || scope.contains(","))) {
            scope = OAuth2Utils.parseParameterList(value);
        }
        this.scope = scope == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(scope);
        this.authorizationParameters.put("scope", OAuth2Utils.formatParameterList(scope));
    }

    public void setResourceIds(Set<String> resourceIds) {
        this.resourceIds = resourceIds == null ? new HashSet<String>() : new HashSet<String>(resourceIds);
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities == null ? new HashSet<GrantedAuthority>() : new HashSet<GrantedAuthority>(authorities);
    }

    public void setAuthorizationParameters(Map<String, String> authorizationParameters) {
        String clientId = this.getClientId();
        Set<String> scope = this.getScope();
        Map<String, String> map = this.authorizationParameters = authorizationParameters == null ? new HashMap<String, String>() : new HashMap<String, String>(authorizationParameters);
        if (!authorizationParameters.containsKey("client_id") && clientId != null) {
            this.authorizationParameters.put("client_id", clientId);
        }
        if (StringUtils.hasText((String)authorizationParameters.get("scope"))) {
            this.setScope(OAuth2Utils.parseParameterList(authorizationParameters.get("scope")));
        } else {
            this.setScope(scope);
        }
    }

    public void setApprovalParameters(Map<String, String> approvalParameters) {
        this.approvalParameters = approvalParameters == null ? new HashMap<String, String>() : new HashMap<String, String>(approvalParameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authorities == null ? 0 : ((Object)this.authorities).hashCode());
        result = 31 * result + (this.approved ? 1231 : 1237);
        result = 31 * result + (this.authorizationParameters == null ? 0 : ((Object)this.authorizationParameters).hashCode());
        result = 31 * result + (this.approvalParameters == null ? 0 : ((Object)this.approvalParameters).hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : ((Object)this.resourceIds).hashCode());
        result = 31 * result + (this.scope == null ? 0 : ((Object)this.scope).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAuthorizationRequest other = (DefaultAuthorizationRequest)obj;
        if (this.authorities == null ? other.authorities != null : !((Object)this.authorities).equals(other.authorities)) {
            return false;
        }
        if (this.approved != other.approved) {
            return false;
        }
        if (this.authorizationParameters == null ? other.authorizationParameters != null : !((Object)this.authorizationParameters).equals(other.authorizationParameters)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !((Object)this.resourceIds).equals(other.resourceIds)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !((Object)this.scope).equals(other.scope)) {
            return false;
        }
        return !(this.approvalParameters == null ? other.approvalParameters != null : !((Object)this.approvalParameters).equals(other.approvalParameters));
    }

    public void remove(Collection<String> keys) {
        for (String key : keys) {
            this.authorizationParameters.remove(key);
        }
    }
}

