/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.refresh;

import java.util.Map;
import java.util.Set;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientCredentialsChecker;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshTokenGranter
implements TokenGranter {
    private static final String GRANT_TYPE = "refresh_token";
    private final AuthorizationServerTokenServices tokenServices;
    private final ClientCredentialsChecker clientCredentialsChecker;

    public RefreshTokenGranter(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService) {
        this.clientCredentialsChecker = new ClientCredentialsChecker(clientDetailsService);
        this.tokenServices = tokenServices;
    }

    @Override
    public OAuth2AccessToken grant(String grantType, Map<String, String> parameters, String clientId, Set<String> scope) {
        if (!GRANT_TYPE.equals(grantType)) {
            return null;
        }
        this.clientCredentialsChecker.validateCredentials(grantType, clientId);
        String refreshToken = parameters.get(GRANT_TYPE);
        return this.tokenServices.refreshAccessToken(refreshToken, scope);
    }
}

