/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.config.ProviderBeanDefinitionParser;
import org.springframework.security.oauth2.provider.error.DefaultProviderExceptionHandler;
import org.springframework.security.oauth2.provider.filter.CompositeFilter;
import org.springframework.security.oauth2.provider.filter.OAuth2ExceptionHandlerFilter;
import org.springframework.security.oauth2.provider.filter.OAuth2ProtectedResourceFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ResourceServerBeanDefinitionParser
extends ProviderBeanDefinitionParser {
    protected AbstractBeanDefinition parseEndpointAndReturnFilter(Element element, ParserContext parserContext, String tokenServicesRef, String serializerRef) {
        ManagedList filters = new ManagedList();
        BeanDefinitionBuilder exceptionHandlerFilter = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ExceptionHandlerFilter.class);
        if (StringUtils.hasText((String)serializerRef)) {
            BeanDefinitionBuilder exceptionHandler = BeanDefinitionBuilder.rootBeanDefinition(DefaultProviderExceptionHandler.class);
            exceptionHandler.addPropertyReference("serializationService", serializerRef);
            exceptionHandlerFilter.addPropertyValue("providerExceptionHandler", (Object)exceptionHandler.getBeanDefinition());
        }
        parserContext.getRegistry().registerBeanDefinition("oauth2ExceptionHandlerFilter", (BeanDefinition)exceptionHandlerFilter.getBeanDefinition());
        filters.add((Object)new RuntimeBeanReference("oauth2ExceptionHandlerFilter"));
        String resourceId = element.getAttribute("resource-id");
        BeanDefinitionBuilder protectedResourceFilterBean = BeanDefinitionBuilder.rootBeanDefinition(OAuth2ProtectedResourceFilter.class);
        protectedResourceFilterBean.addPropertyReference("tokenServices", tokenServicesRef);
        if (StringUtils.hasText((String)resourceId)) {
            protectedResourceFilterBean.addPropertyValue("resourceId", (Object)resourceId);
        }
        parserContext.getRegistry().registerBeanDefinition("oauth2ProtectedResourceFilter", (BeanDefinition)protectedResourceFilterBean.getBeanDefinition());
        filters.add((Object)new RuntimeBeanReference("oauth2ProtectedResourceFilter"));
        BeanDefinitionBuilder filterChain = BeanDefinitionBuilder.rootBeanDefinition(CompositeFilter.class);
        filterChain.addPropertyValue("filters", (Object)filters);
        return filterChain.getBeanDefinition();
    }
}

