/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common;

import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Set;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.OAuth2Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuth2AccessTokenDeserializer
extends StdDeserializer<OAuth2AccessToken> {
    public OAuth2AccessTokenDeserializer() {
        super(OAuth2AccessToken.class);
    }

    public OAuth2AccessToken deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String tokenValue = null;
        String tokenType = null;
        String refreshToken = null;
        Long expiresIn = null;
        Set<String> scope = null;
        LinkedHashMap<String, Object> additionalInformation = new LinkedHashMap<String, Object>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if (OAuth2AccessToken.ACCESS_TOKEN.equals(name)) {
                tokenValue = jp.getText();
                continue;
            }
            if (OAuth2AccessToken.TOKEN_TYPE.equals(name)) {
                tokenType = jp.getText();
                continue;
            }
            if (OAuth2AccessToken.REFRESH_TOKEN.equals(name)) {
                refreshToken = jp.getText();
                continue;
            }
            if (OAuth2AccessToken.EXPIRES_IN.equals(name)) {
                expiresIn = jp.getLongValue();
                continue;
            }
            if (OAuth2AccessToken.SCOPE.equals(name)) {
                String text = jp.getText();
                scope = OAuth2Utils.parseParameterList(text);
                continue;
            }
            additionalInformation.put(name, jp.readValueAs(Object.class));
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenValue);
        accessToken.setTokenType(tokenType);
        if (expiresIn != null) {
            accessToken.setExpiration(new Date(System.currentTimeMillis() + expiresIn * 1000L));
        }
        if (refreshToken != null) {
            accessToken.setRefreshToken(new OAuth2RefreshToken(refreshToken));
        }
        accessToken.setScope(scope);
        accessToken.setAdditionalInformation(additionalInformation);
        return accessToken;
    }
}

