/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.security.oauth2.common.OAuth2AccessTokenDeserializer;
import org.springframework.security.oauth2.common.OAuth2AccessTokenSerializer;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(using=OAuth2AccessTokenSerializer.class)
@JsonDeserialize(using=OAuth2AccessTokenDeserializer.class)
public class OAuth2AccessToken
implements Serializable {
    private static final long serialVersionUID = 914967629530462926L;
    public static String BEARER_TYPE = "Bearer";
    public static String OAUTH2_TYPE = "OAuth2";
    public static String ACCESS_TOKEN = "access_token";
    public static String TOKEN_TYPE = "token_type";
    public static String EXPIRES_IN = "expires_in";
    public static String REFRESH_TOKEN = "refresh_token";
    public static String SCOPE = "scope";
    private String value;
    private Date expiration;
    private String tokenType = BEARER_TYPE.toLowerCase();
    private OAuth2RefreshToken refreshToken;
    private Set<String> scope;
    private Map<String, Object> additionalInformation = Collections.emptyMap();

    public OAuth2AccessToken(String value) {
        this.value = value;
    }

    private OAuth2AccessToken() {
        this(null);
    }

    public String getValue() {
        return this.value;
    }

    public int getExpiresIn() {
        return this.expiration != null ? Long.valueOf((this.expiration.getTime() - System.currentTimeMillis()) / 1000L).intValue() : 0;
    }

    protected void setExpiresIn(int delta) {
        this.setExpiration(new Date(System.currentTimeMillis() + (long)delta));
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public boolean isExpired() {
        return this.expiration != null && this.expiration.before(new Date());
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public OAuth2RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(OAuth2RefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    public boolean equals(Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }

    public static OAuth2AccessToken valueOf(Map<String, String> tokenParams) {
        OAuth2AccessToken token = new OAuth2AccessToken(tokenParams.get(ACCESS_TOKEN));
        if (tokenParams.containsKey(EXPIRES_IN)) {
            long expiration = 0L;
            try {
                expiration = Long.parseLong(String.valueOf(tokenParams.get(EXPIRES_IN)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            token.setExpiration(new Date(System.currentTimeMillis() + expiration * 1000L));
        }
        if (tokenParams.containsKey(REFRESH_TOKEN)) {
            String refresh = tokenParams.get(REFRESH_TOKEN);
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refresh);
            token.setRefreshToken(refreshToken);
        }
        if (tokenParams.containsKey(SCOPE)) {
            TreeSet<String> scope = new TreeSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(tokenParams.get(SCOPE), " ,");
            while (tokenizer.hasMoreTokens()) {
                scope.add(tokenizer.nextToken());
            }
            token.setScope(scope);
        }
        if (tokenParams.containsKey(TOKEN_TYPE)) {
            token.setTokenType(tokenParams.get(TOKEN_TYPE));
        }
        return token;
    }

    public Map<String, Object> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(Map<String, Object> additionalInformation) {
        this.additionalInformation = new LinkedHashMap<String, Object>(additionalInformation);
    }
}

