/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.http.StringSplitUtils;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;

public class OAuth2ErrorHandler
implements ResponseErrorHandler {
    private final ResponseErrorHandler errorHandler;
    private final OAuth2ProtectedResourceDetails resource;

    public OAuth2ErrorHandler(OAuth2ProtectedResourceDetails resource) {
        this((ResponseErrorHandler)new DefaultResponseErrorHandler(), resource);
    }

    public OAuth2ErrorHandler(ResponseErrorHandler errorHandler, OAuth2ProtectedResourceDetails resource) {
        this.resource = resource;
        this.errorHandler = errorHandler;
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.errorHandler.hasError(response);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        List authenticateHeaders = response.getHeaders().get((Object)"WWW-Authenticate");
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                this.maybeThrowExceptionFromHeader(authenticateHeader, OAuth2AccessToken.BEARER_TYPE);
                this.maybeThrowExceptionFromHeader(authenticateHeader, OAuth2AccessToken.OAUTH2_TYPE);
            }
        }
        this.errorHandler.handleError(response);
    }

    private void maybeThrowExceptionFromHeader(String authenticateHeader, String headerType) {
        headerType = headerType.toLowerCase();
        if (authenticateHeader.toLowerCase().startsWith(headerType)) {
            Map<String, String> headerEntries = StringSplitUtils.splitEachArrayElementAndCreateMap(StringSplitUtils.splitIgnoringQuotes(authenticateHeader.substring(headerType.length()), ','), "=", "\"");
            OAuth2Exception ex = OAuth2Exception.valueOf(headerEntries);
            if (ex instanceof InvalidTokenException) {
                throw new AccessTokenRequiredException(this.resource);
            }
            throw ex;
        }
    }
}

