/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.filter.state;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth2.client.filter.state.StatePersistenceServices;

public class HttpSessionStatePersistenceServices
implements StatePersistenceServices {
    public static final String STATE_PREFIX = HttpSessionStatePersistenceServices.class.getName() + "#STATE#";
    private boolean allowSessionCreation = true;

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public Object loadPreservedState(String id, HttpServletRequest request, HttpServletResponse response) {
        Object state = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            state = session.getAttribute(STATE_PREFIX + id);
            session.removeAttribute(STATE_PREFIX + id);
        }
        return state;
    }

    public void preserveState(String id, Object state, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(this.allowSessionCreation);
        if (session != null) {
            session.setAttribute(STATE_PREFIX + id, state);
        }
    }
}

