/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.oauth2.client.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.context.OAuth2ClientContext;
import org.springframework.security.oauth2.client.context.OAuth2ClientContextHolder;
import org.springframework.security.oauth2.client.filter.cache.AccessTokenCache;
import org.springframework.security.oauth2.client.filter.cache.HttpSessionAccessTokenCache;
import org.springframework.security.oauth2.client.filter.state.HttpSessionStatePersistenceServices;
import org.springframework.security.oauth2.client.filter.state.StatePersistenceServices;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class OAuth2ClientContextFilter
implements Filter,
InitializingBean {
    private AccessTokenProvider accessTokenProvider = new AccessTokenProviderChain(Arrays.asList(new AuthorizationCodeAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
    private AccessTokenCache tokenCache = new HttpSessionAccessTokenCache();
    private StatePersistenceServices statePersistenceServices = new HttpSessionStatePersistenceServices();
    private PortResolver portResolver = new PortResolverImpl();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean redirectOnError = false;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.accessTokenProvider, (String)"An OAuth2 access token provider must be supplied.");
        Assert.notNull((Object)this.tokenCache, (String)"TokenCacheServices must be supplied.");
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Map<String, OAuth2AccessToken> accessTokens = this.tokenCache.loadRememberedTokens(request, response);
        OAuth2ClientContext oauth2Context = new OAuth2ClientContext(accessTokens);
        OAuth2ClientContextHolder.setContext(oauth2Context);
        try {
            try {
                chain.doFilter(servletRequest, servletResponse);
                return;
            }
            catch (Exception ex) {
                OAuth2ProtectedResourceDetails resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(ex);
                oauth2Context.removeAccessToken(resourceThatNeedsAuthorization);
                Map parameters = request.getParameterMap();
                AccessTokenRequest accessTokenRequest = new AccessTokenRequest(parameters);
                accessTokenRequest.setCurrentUri(this.calculateCurrentUri(request));
                String stateKey = request.getParameter("state");
                if (stateKey != null) {
                    Object preservedState = this.statePersistenceServices.loadPreservedState(stateKey, request, response);
                    if (preservedState == null) {
                        throw new InvalidRequestException("Possible CSRF detected - state parameter was present but no state could be found");
                    }
                    accessTokenRequest.setPreservedState(preservedState);
                }
                while (!oauth2Context.containsResource(resourceThatNeedsAuthorization)) {
                    OAuth2AccessToken accessToken;
                    OAuth2AccessToken existingToken = oauth2Context.getAccessToken(resourceThatNeedsAuthorization);
                    if (existingToken != null) {
                        accessTokenRequest.setExistingToken(existingToken);
                    }
                    try {
                        accessToken = this.accessTokenProvider.obtainAccessToken(resourceThatNeedsAuthorization, accessTokenRequest);
                        if (accessToken == null) {
                            throw new IllegalStateException("Access token manager returned a null access token, which is illegal according to the contract.");
                        }
                    }
                    catch (UserRedirectRequiredException e) {
                        this.redirectUser(resourceThatNeedsAuthorization, e, request, response);
                        OAuth2ClientContextHolder.clearContext();
                        this.tokenCache.rememberTokens(oauth2Context.getNewAccessTokens(), request, response);
                        return;
                    }
                    try {
                        oauth2Context.addAccessToken(resourceThatNeedsAuthorization, accessToken);
                        try {
                            if (!response.isCommitted() && !this.redirectOnError) {
                                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                continue;
                            }
                            String redirect = request.getServletPath();
                            if (request.getQueryString() != null) {
                                redirect = redirect + "?" + request.getQueryString();
                            }
                            this.redirectStrategy.sendRedirect(request, response, redirect);
                        }
                        catch (Exception e) {
                            resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(e);
                            oauth2Context.removeAccessToken(resourceThatNeedsAuthorization);
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            OAuth2ClientContextHolder.clearContext();
            this.tokenCache.rememberTokens(oauth2Context.getNewAccessTokens(), request, response);
        }
    }

    protected void redirectUser(OAuth2ProtectedResourceDetails resource, UserRedirectRequiredException e, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUri = e.getRedirectUri();
        StringBuilder builder = new StringBuilder(redirectUri);
        Map<String, String> requestParams = e.getRequestParams();
        int appendChar = redirectUri.indexOf(63) < 0 ? 63 : 38;
        for (Map.Entry<String, String> param : requestParams.entrySet()) {
            try {
                builder.append((char)appendChar).append(param.getKey()).append('=').append(URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException(uee);
            }
            appendChar = 38;
        }
        if (e.getStateKey() != null) {
            builder.append((char)appendChar).append("state").append('=').append(e.getStateKey());
            Object stateToPreserve = e.getStateToPreserve();
            if (stateToPreserve == null) {
                stateToPreserve = "state";
            }
            this.statePersistenceServices.preserveState(e.getStateKey(), stateToPreserve, request, response);
        }
        this.redirectStrategy.sendRedirect(request, response, builder.toString());
    }

    protected OAuth2ProtectedResourceDetails checkForResourceThatNeedsAuthorization(Exception ex) throws ServletException, IOException {
        OAuth2ProtectedResourceDetails resourceThatNeedsAuthorization;
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
        AccessTokenRequiredException ase = (AccessTokenRequiredException)((Object)this.throwableAnalyzer.getFirstThrowableOfType(AccessTokenRequiredException.class, causeChain));
        if (ase != null) {
            resourceThatNeedsAuthorization = ase.getResource();
            if (resourceThatNeedsAuthorization == null) {
                throw new OAuth2AccessDeniedException(ase.getMessage());
            }
        } else {
            if (ex instanceof ServletException) {
                throw (ServletException)((Object)ex);
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return resourceThatNeedsAuthorization;
    }

    protected String calculateCurrentUri(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder queryBuilder = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            if (!"code".equals(name)) {
                String[] parameterValues = request.getParameterValues(name);
                if (parameterValues.length == 0) {
                    queryBuilder.append(URLEncoder.encode(name, "UTF-8"));
                } else {
                    for (int i = 0; i < parameterValues.length; ++i) {
                        String parameterValue = parameterValues[i];
                        queryBuilder.append(URLEncoder.encode(name, "UTF-8")).append('=').append(URLEncoder.encode(parameterValue, "UTF-8"));
                        if (i + 1 >= parameterValues.length) continue;
                        queryBuilder.append('&');
                    }
                }
            }
            if (!paramNames.hasMoreElements() || queryBuilder.length() <= 0) continue;
            queryBuilder.append('&');
        }
        return UrlUtils.buildFullRequestUrl((String)request.getScheme(), (String)request.getServerName(), (int)this.portResolver.getServerPort((ServletRequest)request), (String)request.getRequestURI(), (String)(queryBuilder.length() > 0 ? queryBuilder.toString() : null));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void setAccessTokenProvider(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }

    public void setClientTokenCache(AccessTokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public void setStatePersistenceServices(StatePersistenceServices stateServices) {
        this.statePersistenceServices = stateServices;
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void setRedirectOnError(boolean redirectOnError) {
        this.redirectOnError = redirectOnError;
    }
}

