/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.provider.InvalidOAuthParametersException;
import org.springframework.security.oauth.provider.token.InvalidOAuthTokenException;
import org.springframework.security.oauth.provider.token.OAuthProviderToken;
import org.springframework.security.oauth.provider.token.OAuthProviderTokenServices;
import org.springframework.security.oauth.provider.verifier.OAuthVerifierServices;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.Assert;

public class UserAuthorizationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    protected static final String CALLBACK_ATTRIBUTE = String.valueOf(UserAuthorizationProcessingFilter.class.getName()) + "#CALLBACK";
    protected static final String VERIFIER_ATTRIBUTE = String.valueOf(UserAuthorizationProcessingFilter.class.getName()) + "#VERIFIER";
    private OAuthProviderTokenServices tokenServices;
    private String tokenIdParameterName = "requestToken";
    private OAuthVerifierServices verifierServices;
    private boolean require10a = true;

    public UserAuthorizationProcessingFilter() {
        super("/oauth_authenticate_token");
    }

    public UserAuthorizationProcessingFilter(String defaultProcessesUrl) {
        super(defaultProcessesUrl);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.getTokenServices(), (String)"A token services must be provided.");
        Assert.notNull((Object)this.getVerifierServices(), (String)"Verifier services are required.");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication;
        String requestToken = request.getParameter(this.getTokenParameterName());
        if (requestToken == null) {
            throw new InvalidOAuthParametersException("An OAuth token id is required.");
        }
        OAuthProviderToken token = this.getTokenServices().getToken(requestToken);
        if (token == null) {
            throw new InvalidOAuthTokenException("No callback value has been provided for request token " + requestToken + ".");
        }
        String callbackURL = token.getCallbackUrl();
        if (this.isRequire10a() && callbackURL == null) {
            throw new InvalidOAuthTokenException("No callback value has been provided for request token " + requestToken + ".");
        }
        if (callbackURL != null) {
            request.setAttribute(CALLBACK_ATTRIBUTE, (Object)callbackURL);
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null || !authentication.isAuthenticated()) {
            throw new InsufficientAuthenticationException("User must be authenticated before authorizing a request token.");
        }
        String verifier = this.getVerifierServices().createVerifier();
        request.setAttribute(VERIFIER_ATTRIBUTE, (Object)verifier);
        this.getTokenServices().authorizeRequestToken(requestToken, verifier, authentication);
        return authentication;
    }

    public String getTokenParameterName() {
        return this.tokenIdParameterName;
    }

    public void setTokenIdParameterName(String tokenIdParameterName) {
        this.tokenIdParameterName = tokenIdParameterName;
    }

    public OAuthProviderTokenServices getTokenServices() {
        return this.tokenServices;
    }

    @Autowired
    public void setTokenServices(OAuthProviderTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public OAuthVerifierServices getVerifierServices() {
        return this.verifierServices;
    }

    @Autowired
    public void setVerifierServices(OAuthVerifierServices verifierServices) {
        this.verifierServices = verifierServices;
    }

    public boolean isRequire10a() {
        return this.require10a;
    }

    public void setRequire10a(boolean require10a) {
        this.require10a = require10a;
    }
}

