/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.codec.DecoderException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth.common.OAuthCodec;
import org.springframework.security.oauth.common.OAuthConsumerParameter;
import org.springframework.security.oauth.common.OAuthProviderParameter;
import org.springframework.security.oauth.common.StringSplitUtils;
import org.springframework.security.oauth.common.signature.CoreOAuthSignatureMethodFactory;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethodFactory;
import org.springframework.security.oauth.common.signature.UnsupportedSignatureMethodException;
import org.springframework.security.oauth.consumer.InvalidOAuthRealmException;
import org.springframework.security.oauth.consumer.OAuthConsumerSupport;
import org.springframework.security.oauth.consumer.OAuthConsumerToken;
import org.springframework.security.oauth.consumer.OAuthRequestFailedException;
import org.springframework.security.oauth.consumer.ProtectedResourceDetails;
import org.springframework.security.oauth.consumer.ProtectedResourceDetailsService;
import org.springframework.security.oauth.consumer.UnverifiedRequestTokenException;
import org.springframework.security.oauth.consumer.net.OAuthURLStreamHandlerFactory;
import org.springframework.security.oauth.consumer.nonce.NonceFactory;
import org.springframework.security.oauth.consumer.nonce.UUIDNonceFactory;
import org.springframework.util.Assert;

public class CoreOAuthConsumerSupport
implements OAuthConsumerSupport,
InitializingBean {
    private OAuthURLStreamHandlerFactory streamHandlerFactory;
    private OAuthSignatureMethodFactory signatureFactory = new CoreOAuthSignatureMethodFactory();
    private NonceFactory nonceFactory = new UUIDNonceFactory();
    private ProtectedResourceDetailsService protectedResourceDetailsService;
    private ProxySelector proxySelector = ProxySelector.getDefault();
    private int connectionTimeout = 60000;
    private int readTimeout = 60000;

    public CoreOAuthConsumerSupport() {
        try {
            this.streamHandlerFactory = (OAuthURLStreamHandlerFactory)Class.forName("org.springframework.security.oauth.consumer.net.DefaultOAuthURLStreamHandlerFactory").newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public CoreOAuthConsumerSupport(OAuthURLStreamHandlerFactory streamHandlerFactory) {
        this.streamHandlerFactory = streamHandlerFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.protectedResourceDetailsService, (String)"A protected resource details service is required.");
        Assert.notNull((Object)this.streamHandlerFactory, (String)"A stream handler factory is required.");
    }

    @Override
    public OAuthConsumerToken getUnauthorizedRequestToken(String resourceId, String callback) throws OAuthRequestFailedException {
        ProtectedResourceDetails details = this.getProtectedResourceDetailsService().loadProtectedResourceDetailsById(resourceId);
        return this.getUnauthorizedRequestToken(details, callback);
    }

    @Override
    public OAuthConsumerToken getUnauthorizedRequestToken(ProtectedResourceDetails details, String callback) throws OAuthRequestFailedException {
        Map<String, String> specifiedParams;
        URL requestTokenURL;
        try {
            requestTokenURL = new URL(details.getRequestTokenURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed URL for obtaining a request token.", e);
        }
        String httpMethod = details.getRequestTokenHttpMethod();
        TreeMap<String, String> additionalParameters = new TreeMap<String, String>();
        if (details.isUse10a()) {
            additionalParameters.put(OAuthConsumerParameter.oauth_callback.toString(), callback);
        }
        if ((specifiedParams = details.getAdditionalParameters()) != null) {
            additionalParameters.putAll(specifiedParams);
        }
        return this.getTokenFromProvider(details, requestTokenURL, httpMethod, null, additionalParameters);
    }

    @Override
    public OAuthConsumerToken getAccessToken(OAuthConsumerToken requestToken, String verifier) throws OAuthRequestFailedException {
        ProtectedResourceDetails details = this.getProtectedResourceDetailsService().loadProtectedResourceDetailsById(requestToken.getResourceId());
        return this.getAccessToken(details, requestToken, verifier);
    }

    @Override
    public OAuthConsumerToken getAccessToken(ProtectedResourceDetails details, OAuthConsumerToken requestToken, String verifier) {
        Map<String, String> specifiedParams;
        URL accessTokenURL;
        try {
            accessTokenURL = new URL(details.getAccessTokenURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed URL for obtaining an access token.", e);
        }
        String httpMethod = details.getAccessTokenHttpMethod();
        TreeMap<String, String> additionalParameters = new TreeMap<String, String>();
        if (details.isUse10a()) {
            if (verifier == null) {
                throw new UnverifiedRequestTokenException("Unverified request token: " + requestToken);
            }
            additionalParameters.put(OAuthConsumerParameter.oauth_verifier.toString(), verifier);
        }
        if ((specifiedParams = details.getAdditionalParameters()) != null) {
            additionalParameters.putAll(specifiedParams);
        }
        return this.getTokenFromProvider(details, accessTokenURL, httpMethod, requestToken, additionalParameters);
    }

    @Override
    public InputStream readProtectedResource(URL url, OAuthConsumerToken accessToken, String httpMethod) throws OAuthRequestFailedException {
        if (accessToken == null) {
            throw new OAuthRequestFailedException("A valid access token must be supplied.");
        }
        ProtectedResourceDetails resourceDetails = this.getProtectedResourceDetailsService().loadProtectedResourceDetailsById(accessToken.getResourceId());
        if (!(resourceDetails.isAcceptsAuthorizationHeader() || "POST".equalsIgnoreCase(httpMethod) || "PUT".equalsIgnoreCase(httpMethod))) {
            throw new IllegalArgumentException("Protected resource " + resourceDetails.getId() + " cannot be accessed with HTTP method " + httpMethod + " because the OAuth provider doesn't accept the OAuth Authorization header.");
        }
        return this.readResource(resourceDetails, url, httpMethod, accessToken, resourceDetails.getAdditionalParameters(), null);
    }

    protected InputStream readResource(ProtectedResourceDetails details, URL url, String httpMethod, OAuthConsumerToken token, Map<String, String> additionalParameters, Map<String, String> additionalRequestHeaders) {
        String responseMessage;
        int responseCode;
        url = this.configureURLForProtectedAccess(url, token, details, httpMethod, additionalParameters);
        String realm = details.getAuthorizationHeaderRealm();
        boolean sendOAuthParamsInRequestBody = !details.isAcceptsAuthorizationHeader() && ("POST".equalsIgnoreCase(httpMethod) || "PUT".equalsIgnoreCase(httpMethod));
        HttpURLConnection connection = this.openConnection(url);
        try {
            connection.setRequestMethod(httpMethod);
        }
        catch (ProtocolException e) {
            throw new IllegalStateException(e);
        }
        Map<String, String> reqHeaders = details.getAdditionalRequestHeaders();
        if (reqHeaders != null) {
            for (Map.Entry<String, String> requestHeader : reqHeaders.entrySet()) {
                connection.setRequestProperty(requestHeader.getKey(), requestHeader.getValue());
            }
        }
        if (additionalRequestHeaders != null) {
            for (Map.Entry<String, String> requestHeader : additionalRequestHeaders.entrySet()) {
                connection.setRequestProperty(requestHeader.getKey(), requestHeader.getValue());
            }
        }
        try {
            connection.setDoOutput(sendOAuthParamsInRequestBody);
            connection.connect();
            if (sendOAuthParamsInRequestBody) {
                String queryString = this.getOAuthQueryString(details, token, url, httpMethod, additionalParameters);
                OutputStream out = connection.getOutputStream();
                out.write(queryString.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
            if (responseMessage == null) {
                responseMessage = "Unknown Error";
            }
        }
        catch (IOException e) {
            throw new OAuthRequestFailedException("OAuth connection failed.", e);
        }
        if (responseCode >= 200 && responseCode < 300) {
            try {
                return connection.getInputStream();
            }
            catch (IOException e) {
                throw new OAuthRequestFailedException("Unable to get the input stream from a successful response.", e);
            }
        }
        if (responseCode == 400) {
            throw new OAuthRequestFailedException("OAuth authentication failed: " + responseMessage);
        }
        if (responseCode == 401) {
            Map<String, String> headerEntries;
            String requiredRealm;
            String authHeaderValue = connection.getHeaderField("WWW-Authenticate");
            if (authHeaderValue != null && (requiredRealm = (headerEntries = StringSplitUtils.splitEachArrayElementAndCreateMap(StringSplitUtils.splitIgnoringQuotes(authHeaderValue, ','), "=", "\"")).get("realm")) != null && !requiredRealm.equals(realm)) {
                throw new InvalidOAuthRealmException(String.format("Invalid OAuth realm. Provider expects \"%s\", when the resource details specify \"%s\".", requiredRealm, realm), requiredRealm);
            }
            throw new OAuthRequestFailedException("OAuth authentication failed: " + responseMessage);
        }
        throw new OAuthRequestFailedException(String.format("Invalid response code %s (%s).", responseCode, responseMessage));
    }

    @Override
    public URL configureURLForProtectedAccess(URL url, OAuthConsumerToken accessToken, String httpMethod, Map<String, String> additionalParameters) throws OAuthRequestFailedException {
        return this.configureURLForProtectedAccess(url, accessToken, this.getProtectedResourceDetailsService().loadProtectedResourceDetailsById(accessToken.getResourceId()), httpMethod, additionalParameters);
    }

    protected URL configureURLForProtectedAccess(URL url, OAuthConsumerToken requestToken, ProtectedResourceDetails details, String httpMethod, Map<String, String> additionalParameters) {
        String file;
        if (!("POST".equalsIgnoreCase(httpMethod) || "PUT".equalsIgnoreCase(httpMethod) || details.isAcceptsAuthorizationHeader())) {
            StringBuilder fileb = new StringBuilder(url.getPath());
            String queryString = this.getOAuthQueryString(details, requestToken, url, httpMethod, additionalParameters);
            fileb.append('?').append(queryString);
            file = fileb.toString();
        } else {
            file = url.getFile();
        }
        try {
            URLStreamHandler streamHandler;
            if ("http".equalsIgnoreCase(url.getProtocol())) {
                streamHandler = this.getStreamHandlerFactory().getHttpStreamHandler(details, requestToken, this, httpMethod, additionalParameters);
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file, streamHandler);
            }
            if ("https".equalsIgnoreCase(url.getProtocol())) {
                streamHandler = this.getStreamHandlerFactory().getHttpsStreamHandler(details, requestToken, this, httpMethod, additionalParameters);
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file, streamHandler);
            }
            throw new OAuthRequestFailedException("Unsupported OAuth protocol: " + url.getProtocol());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getAuthorizationHeader(ProtectedResourceDetails details, OAuthConsumerToken accessToken, URL url, String httpMethod, Map<String, String> additionalParameters) {
        if (!details.isAcceptsAuthorizationHeader()) {
            return null;
        }
        Map<String, Set<CharSequence>> oauthParams = this.loadOAuthParameters(details, url, accessToken, httpMethod, additionalParameters);
        String realm = details.getAuthorizationHeaderRealm();
        StringBuilder builder = new StringBuilder("OAuth ");
        boolean writeComma = false;
        if (realm != null) {
            builder.append("realm=\"").append(realm).append('\"');
            writeComma = true;
        }
        for (Map.Entry<String, Set<CharSequence>> paramValuesEntry : oauthParams.entrySet()) {
            Set<CharSequence> paramValues = paramValuesEntry.getValue();
            String paramValue = this.findValidHeaderValue(paramValues);
            if (paramValue == null) continue;
            if (writeComma) {
                builder.append(", ");
            }
            builder.append(paramValuesEntry.getKey()).append("=\"").append(OAuthCodec.oauthEncode(paramValue.toString())).append('\"');
            writeComma = true;
        }
        return builder.toString();
    }

    protected String findValidHeaderValue(Set<CharSequence> paramValues) {
        CharSequence value;
        String selectedValue = null;
        if (paramValues != null && !paramValues.isEmpty() && !((value = paramValues.iterator().next()) instanceof QueryParameterValue)) {
            selectedValue = value.toString();
        }
        return selectedValue;
    }

    @Override
    public String getOAuthQueryString(ProtectedResourceDetails details, OAuthConsumerToken accessToken, URL url, String httpMethod, Map<String, String> additionalParameters) {
        Map<String, Set<CharSequence>> oauthParams = this.loadOAuthParameters(details, url, accessToken, httpMethod, additionalParameters);
        StringBuilder queryString = new StringBuilder();
        if (details.isAcceptsAuthorizationHeader()) {
            for (OAuthConsumerParameter oauthParam : OAuthConsumerParameter.values()) {
                oauthParams.remove(oauthParam.toString());
            }
            if (additionalParameters != null) {
                for (String additionalParam : additionalParameters.keySet()) {
                    oauthParams.remove(additionalParam);
                }
            }
        }
        Iterator<String> parametersIt = oauthParams.keySet().iterator();
        while (parametersIt.hasNext()) {
            String parameter = parametersIt.next();
            queryString.append(parameter);
            Set<CharSequence> values = oauthParams.get(parameter);
            if (values != null) {
                Iterator<CharSequence> valuesIt = values.iterator();
                while (valuesIt.hasNext()) {
                    CharSequence parameterValue = valuesIt.next();
                    if (parameterValue != null) {
                        queryString.append('=').append(this.urlEncode(parameterValue.toString()));
                    }
                    if (!valuesIt.hasNext()) continue;
                    queryString.append('&').append(parameter);
                }
            }
            if (!parametersIt.hasNext()) continue;
            queryString.append('&');
        }
        return queryString.toString();
    }

    protected OAuthConsumerToken getTokenFromProvider(ProtectedResourceDetails details, URL tokenURL, String httpMethod, OAuthConsumerToken requestToken, Map<String, String> additionalParameters) {
        String tokenInfo;
        boolean isAccessToken;
        boolean bl = isAccessToken = requestToken != null;
        if (!isAccessToken) {
            requestToken = new OAuthConsumerToken();
        }
        TreeMap<String, String> requestHeaders = new TreeMap<String, String>();
        if ("POST".equalsIgnoreCase(httpMethod)) {
            requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        }
        InputStream inputStream = this.readResource(details, tokenURL, httpMethod, requestToken, additionalParameters, requestHeaders);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = inputStream.read(buffer);
            while (len >= 0) {
                out.write(buffer, 0, len);
                len = inputStream.read(buffer);
            }
            tokenInfo = new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new OAuthRequestFailedException("Unable to read the token.", e);
        }
        StringTokenizer tokenProperties = new StringTokenizer(tokenInfo, "&");
        TreeMap<String, String> tokenPropertyValues = new TreeMap<String, String>();
        while (tokenProperties.hasMoreElements()) {
            try {
                String tokenProperty = (String)tokenProperties.nextElement();
                int equalsIndex = tokenProperty.indexOf(61);
                if (equalsIndex > 0) {
                    String propertyName = OAuthCodec.oauthDecode(tokenProperty.substring(0, equalsIndex));
                    String propertyValue = OAuthCodec.oauthDecode(tokenProperty.substring(equalsIndex + 1));
                    tokenPropertyValues.put(propertyName, propertyValue);
                    continue;
                }
                tokenProperty = OAuthCodec.oauthDecode(tokenProperty);
                tokenPropertyValues.put(tokenProperty, null);
            }
            catch (DecoderException e) {
                throw new OAuthRequestFailedException("Unable to decode token parameters.");
            }
        }
        String tokenValue = (String)tokenPropertyValues.remove(OAuthProviderParameter.oauth_token.toString());
        if (tokenValue == null) {
            throw new OAuthRequestFailedException("OAuth provider failed to return a token.");
        }
        String tokenSecret = (String)tokenPropertyValues.remove(OAuthProviderParameter.oauth_token_secret.toString());
        if (tokenSecret == null) {
            throw new OAuthRequestFailedException("OAuth provider failed to return a token secret.");
        }
        OAuthConsumerToken consumerToken = new OAuthConsumerToken();
        consumerToken.setValue(tokenValue);
        consumerToken.setSecret(tokenSecret);
        consumerToken.setResourceId(details.getId());
        consumerToken.setAccessToken(isAccessToken);
        if (!tokenPropertyValues.isEmpty()) {
            consumerToken.setAdditionalParameters(tokenPropertyValues);
        }
        return consumerToken;
    }

    protected Map<String, Set<CharSequence>> loadOAuthParameters(ProtectedResourceDetails details, URL requestURL, OAuthConsumerToken requestToken, String httpMethod, Map<String, String> additionalParameters) {
        OAuthSignatureMethod signatureMethod;
        String query;
        TreeMap<String, Set<CharSequence>> oauthParams = new TreeMap<String, Set<CharSequence>>();
        if (additionalParameters != null) {
            for (Map.Entry<String, String> additionalParam : additionalParameters.entrySet()) {
                HashSet<String> values = (HashSet<String>)oauthParams.get(additionalParam.getKey());
                if (values == null) {
                    values = new HashSet<String>();
                    oauthParams.put(additionalParam.getKey(), values);
                }
                if (additionalParam.getValue() == null) continue;
                values.add(additionalParam.getValue());
            }
        }
        if ((query = requestURL.getQuery()) != null) {
            StringTokenizer queryTokenizer = new StringTokenizer(query, "&");
            while (queryTokenizer.hasMoreElements()) {
                String token = (String)queryTokenizer.nextElement();
                QueryParameterValue value = null;
                int equalsIndex = token.indexOf(61);
                if (equalsIndex < 0) {
                    token = this.urlDecode(token);
                } else {
                    value = new QueryParameterValue(this.urlDecode(token.substring(equalsIndex + 1)));
                    token = this.urlDecode(token.substring(0, equalsIndex));
                }
                HashSet<QueryParameterValue> values = (HashSet<QueryParameterValue>)oauthParams.get(token);
                if (values == null) {
                    values = new HashSet<QueryParameterValue>();
                    oauthParams.put(token, values);
                }
                if (value == null) continue;
                values.add(value);
            }
        }
        String tokenSecret = requestToken == null ? null : requestToken.getSecret();
        String nonce = this.getNonceFactory().generateNonce();
        oauthParams.put(OAuthConsumerParameter.oauth_consumer_key.toString(), Collections.singleton(details.getConsumerKey()));
        if (requestToken != null && requestToken.getValue() != null) {
            oauthParams.put(OAuthConsumerParameter.oauth_token.toString(), Collections.singleton(requestToken.getValue()));
        }
        oauthParams.put(OAuthConsumerParameter.oauth_nonce.toString(), Collections.singleton(nonce));
        oauthParams.put(OAuthConsumerParameter.oauth_signature_method.toString(), Collections.singleton(details.getSignatureMethod()));
        oauthParams.put(OAuthConsumerParameter.oauth_timestamp.toString(), Collections.singleton(String.valueOf(System.currentTimeMillis() / 1000L)));
        oauthParams.put(OAuthConsumerParameter.oauth_version.toString(), Collections.singleton("1.0"));
        String signatureBaseString = this.getSignatureBaseString(oauthParams, requestURL, httpMethod);
        try {
            signatureMethod = this.getSignatureFactory().getSignatureMethod(details.getSignatureMethod(), details.getSharedSecret(), tokenSecret);
        }
        catch (UnsupportedSignatureMethodException e) {
            throw new OAuthRequestFailedException(e.getMessage(), e);
        }
        String signature = signatureMethod.sign(signatureBaseString);
        oauthParams.put(OAuthConsumerParameter.oauth_signature.toString(), Collections.singleton(signature));
        return oauthParams;
    }

    protected String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String urlDecode(String token) {
        try {
            return URLDecoder.decode(token, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpURLConnection openConnection(URL requestTokenURL) {
        try {
            HttpURLConnection connection = (HttpURLConnection)requestTokenURL.openConnection(this.selectProxy(requestTokenURL));
            connection.setConnectTimeout(this.getConnectionTimeout());
            connection.setReadTimeout(this.getReadTimeout());
            return connection;
        }
        catch (IOException e) {
            throw new OAuthRequestFailedException("Failed to open an OAuth connection.", e);
        }
    }

    protected Proxy selectProxy(URL requestTokenURL) {
        try {
            List<Proxy> selectedProxies = this.getProxySelector().select(requestTokenURL.toURI());
            return selectedProxies.isEmpty() ? Proxy.NO_PROXY : selectedProxies.get(0);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String getSignatureBaseString(Map<String, Set<CharSequence>> oauthParams, URL requestURL, String httpMethod) {
        TreeMap sortedParameters = new TreeMap();
        for (Map.Entry<String, Set<CharSequence>> param : oauthParams.entrySet()) {
            String key = OAuthCodec.oauthEncode(param.getKey());
            TreeSet<String> sortedValues = (TreeSet<String>)sortedParameters.get(key);
            if (sortedValues == null) {
                sortedValues = new TreeSet<String>();
                sortedParameters.put(key, sortedValues);
            }
            for (CharSequence value : param.getValue()) {
                sortedValues.add(OAuthCodec.oauthEncode(value.toString()));
            }
        }
        StringBuilder queryString = new StringBuilder();
        Iterator sortedIt = sortedParameters.entrySet().iterator();
        while (sortedIt.hasNext()) {
            Map.Entry sortedParameter = sortedIt.next();
            Iterator sortedParametersIterator = ((TreeSet)sortedParameter.getValue()).iterator();
            while (sortedParametersIterator.hasNext()) {
                String parameterValue = (String)sortedParametersIterator.next();
                if (parameterValue == null) {
                    parameterValue = "";
                }
                queryString.append((String)sortedParameter.getKey()).append('=').append(parameterValue);
                if (!sortedIt.hasNext() && !sortedParametersIterator.hasNext()) continue;
                queryString.append('&');
            }
        }
        StringBuilder url = new StringBuilder(requestURL.getProtocol().toLowerCase()).append("://").append(requestURL.getHost().toLowerCase());
        if (requestURL.getPort() >= 0 && requestURL.getPort() != requestURL.getDefaultPort()) {
            url.append(":").append(requestURL.getPort());
        }
        url.append(requestURL.getPath());
        return httpMethod.toUpperCase() + '&' + OAuthCodec.oauthEncode(url.toString()) + '&' + OAuthCodec.oauthEncode(queryString.toString());
    }

    public ProtectedResourceDetailsService getProtectedResourceDetailsService() {
        return this.protectedResourceDetailsService;
    }

    @Autowired
    public void setProtectedResourceDetailsService(ProtectedResourceDetailsService protectedResourceDetailsService) {
        this.protectedResourceDetailsService = protectedResourceDetailsService;
    }

    public OAuthURLStreamHandlerFactory getStreamHandlerFactory() {
        return this.streamHandlerFactory;
    }

    @Autowired(required=false)
    public void setStreamHandlerFactory(OAuthURLStreamHandlerFactory streamHandlerFactory) {
        this.streamHandlerFactory = streamHandlerFactory;
    }

    public NonceFactory getNonceFactory() {
        return this.nonceFactory;
    }

    @Autowired(required=false)
    public void setNonceFactory(NonceFactory nonceFactory) {
        this.nonceFactory = nonceFactory;
    }

    public OAuthSignatureMethodFactory getSignatureFactory() {
        return this.signatureFactory;
    }

    @Autowired(required=false)
    public void setSignatureFactory(OAuthSignatureMethodFactory signatureFactory) {
        this.signatureFactory = signatureFactory;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    @Autowired(required=false)
    public void setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static class QueryParameterValue
    implements CharSequence {
        private final String value;

        public QueryParameterValue(String value) {
            this.value = value;
        }

        @Override
        public int length() {
            return this.value.length();
        }

        @Override
        public char charAt(int index) {
            return this.value.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.value.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }
    }
}

