/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.RandomValueOAuth2ProviderTokenServices;
import org.springframework.util.Assert;

public class JdbcOAuth2ProviderTokenServices
extends RandomValueOAuth2ProviderTokenServices {
    private static final Log LOG = LogFactory.getLog(JdbcOAuth2ProviderTokenServices.class);
    private static final String DEFAULT_ACCESS_TOKEN_INSERT_STATEMENT = "insert into oauth_access_token (token_id, token, authentication, refresh_token) values (?, ?, ?, ?)";
    private static final String DEFAULT_ACCESS_TOKEN_SELECT_STATEMENT = "select token_id, token from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_AUTHENTICATION_SELECT_STATEMENT = "select token_id, authentication from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_DELETE_STATEMENT = "delete from oauth_access_token where token_id = ?";
    private static final String DEFAULT_ACCESS_TOKEN_DELETE_FROM_REFRESH_TOKEN_STATEMENT = "delete from oauth_access_token where refresh_token = ?";
    private static final String DEFAULT_REFRESH_TOKEN_INSERT_STATEMENT = "insert into oauth_refresh_token (token_id, token, authentication) values (?, ?, ?)";
    private static final String DEFAULT_REFRESH_TOKEN_SELECT_STATEMENT = "select token_id, token from oauth_refresh_token where token_id = ?";
    private static final String DEFAULT_REFRESH_TOKEN_AUTHENTICATION_SELECT_STATEMENT = "select token_id, authentication from oauth_refresh_token where token_id = ?";
    private static final String DEFAULT_REFRESH_TOKEN_DELETE_STATEMENT = "delete from oauth_refresh_token where token_id = ?";
    private String insertAccessTokenSql = "insert into oauth_access_token (token_id, token, authentication, refresh_token) values (?, ?, ?, ?)";
    private String selectAccessTokenSql = "select token_id, token from oauth_access_token where token_id = ?";
    private String selectAccessTokenAuthenticationSql = "select token_id, authentication from oauth_access_token where token_id = ?";
    private String deleteAccessTokenSql = "delete from oauth_access_token where token_id = ?";
    private String insertRefreshTokenSql = "insert into oauth_refresh_token (token_id, token, authentication) values (?, ?, ?)";
    private String selectRefreshTokenSql = "select token_id, token from oauth_refresh_token where token_id = ?";
    private String selectRefreshTokenAuthenticationSql = "select token_id, authentication from oauth_refresh_token where token_id = ?";
    private String deleteRefreshTokenSql = "delete from oauth_refresh_token where token_id = ?";
    private String deleteAccessTokenFromRefreshTokenSql = "delete from oauth_access_token where refresh_token = ?";
    private final JdbcTemplate jdbcTemplate;

    public JdbcOAuth2ProviderTokenServices(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String refreshToken = null;
        if (token.getRefreshToken() != null) {
            refreshToken = token.getRefreshToken().getValue();
        }
        this.jdbcTemplate.update(this.insertAccessTokenSql, new Object[]{token.getValue(), new SqlLobValue(SerializationUtils.serialize(token)), new SqlLobValue(SerializationUtils.serialize((Object)authentication)), refreshToken}, new int[]{12, 2004, 2004, 12});
    }

    protected OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken accessToken;
        block2: {
            accessToken = null;
            try {
                accessToken = (OAuth2AccessToken)this.jdbcTemplate.queryForObject(this.selectAccessTokenSql, (RowMapper)new RowMapper<OAuth2AccessToken>(){

                    public OAuth2AccessToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2AccessToken)SerializationUtils.deserialize(rs.getBytes("token"));
                    }
                }, new Object[]{tokenValue});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + tokenValue));
            }
        }
        return accessToken;
    }

    protected void removeAccessToken(String tokenValue) {
        this.jdbcTemplate.update(this.deleteAccessTokenSql, new Object[]{tokenValue});
    }

    protected OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        OAuth2Authentication authentication;
        block2: {
            authentication = null;
            try {
                authentication = (OAuth2Authentication)((Object)this.jdbcTemplate.queryForObject(this.selectAccessTokenAuthenticationSql, (RowMapper)new RowMapper<OAuth2Authentication>(){

                    public OAuth2Authentication mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2Authentication)((Object)SerializationUtils.deserialize(rs.getBytes("authentication")));
                    }
                }, new Object[]{token.getValue()}));
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + token));
            }
        }
        return authentication;
    }

    protected void storeRefreshToken(ExpiringOAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        this.jdbcTemplate.update(this.insertRefreshTokenSql, new Object[]{refreshToken.getValue(), new SqlLobValue(SerializationUtils.serialize(refreshToken)), new SqlLobValue(SerializationUtils.serialize((Object)authentication))}, new int[]{12, 2004, 2004});
    }

    protected ExpiringOAuth2RefreshToken readRefreshToken(String token) {
        ExpiringOAuth2RefreshToken refreshToken;
        block2: {
            refreshToken = null;
            try {
                refreshToken = (ExpiringOAuth2RefreshToken)this.jdbcTemplate.queryForObject(this.selectRefreshTokenSql, (RowMapper)new RowMapper<ExpiringOAuth2RefreshToken>(){

                    public ExpiringOAuth2RefreshToken mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (ExpiringOAuth2RefreshToken)SerializationUtils.deserialize(rs.getBytes("token"));
                    }
                }, new Object[]{token});
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find refresh token for token " + token));
            }
        }
        return refreshToken;
    }

    protected void removeRefreshToken(String token) {
        this.jdbcTemplate.update(this.deleteRefreshTokenSql, new Object[]{token});
    }

    protected OAuth2Authentication readAuthentication(ExpiringOAuth2RefreshToken token) {
        OAuth2Authentication authentication;
        block2: {
            authentication = null;
            try {
                authentication = (OAuth2Authentication)((Object)this.jdbcTemplate.queryForObject(this.selectRefreshTokenAuthenticationSql, (RowMapper)new RowMapper<OAuth2Authentication>(){

                    public OAuth2Authentication mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return (OAuth2Authentication)((Object)SerializationUtils.deserialize(rs.getBytes("authentication")));
                    }
                }, new Object[]{token.getValue()}));
            }
            catch (EmptyResultDataAccessException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.info((Object)("Failed to find access token for token " + token));
            }
        }
        return authentication;
    }

    protected void removeAccessTokenUsingRefreshToken(String refreshToken) {
        this.jdbcTemplate.update(this.deleteAccessTokenFromRefreshTokenSql, new Object[]{refreshToken}, new int[]{12});
    }

    public void setInsertAccessTokenSql(String insertAccessTokenSql) {
        this.insertAccessTokenSql = insertAccessTokenSql;
    }

    public void setSelectAccessTokenSql(String selectAccessTokenSql) {
        this.selectAccessTokenSql = selectAccessTokenSql;
    }

    public void setDeleteAccessTokenSql(String deleteAccessTokenSql) {
        this.deleteAccessTokenSql = deleteAccessTokenSql;
    }

    public void setInsertRefreshTokenSql(String insertRefreshTokenSql) {
        this.insertRefreshTokenSql = insertRefreshTokenSql;
    }

    public void setSelectRefreshTokenSql(String selectRefreshTokenSql) {
        this.selectRefreshTokenSql = selectRefreshTokenSql;
    }

    public void setDeleteRefreshTokenSql(String deleteRefreshTokenSql) {
        this.deleteRefreshTokenSql = deleteRefreshTokenSql;
    }

    public void setSelectAccessTokenAuthenticationSql(String selectAccessTokenAuthenticationSql) {
        this.selectAccessTokenAuthenticationSql = selectAccessTokenAuthenticationSql;
    }

    public void setSelectRefreshTokenAuthenticationSql(String selectRefreshTokenAuthenticationSql) {
        this.selectRefreshTokenAuthenticationSql = selectRefreshTokenAuthenticationSql;
    }

    public void setDeleteAccessTokenFromRefreshTokenSql(String deleteAccessTokenFromRefreshTokenSql) {
        this.deleteAccessTokenFromRefreshTokenSql = deleteAccessTokenFromRefreshTokenSql;
    }
}

