/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.DefaultThrowableAnalyzer;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.OAuth2ProviderTokenServices;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ProtectedResourceFilter
extends GenericFilterBean {
    private OAuth2ProviderTokenServices tokenServices;
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.getTokenServices(), (String)"OAuth 2 token services must be supplied.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            String token = this.parseToken(request);
            if (token != null) {
                OAuth2Authentication auth = this.getTokenServices().loadAuthentication(token);
                if (auth == null) {
                    throw new InvalidTokenException("Invalid token: " + token);
                }
                SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Chain processed normally");
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable[] causeChain = this.getThrowableAnalyzer().determineCauseChain((Throwable)ex);
            AuthenticationException ase = (AuthenticationException)this.getThrowableAnalyzer().getFirstThrowableOfType(AuthenticationException.class, causeChain);
            if (ase == null) {
                ase = (AccessDeniedException)this.getThrowableAnalyzer().getFirstThrowableOfType(AccessDeniedException.class, causeChain);
            }
            if (ase != null) {
                String error = null;
                String errorMessage = null;
                Map<String, String> additionalParams = null;
                if (ase instanceof OAuth2Exception) {
                    error = ((OAuth2Exception)ase).getOAuth2ErrorCode();
                    errorMessage = ase.getMessage();
                    additionalParams = ((OAuth2Exception)ase).getAdditionalInformation();
                }
                this.setAuthenticateHeader(response, error, errorMessage, additionalParams);
                throw ase;
            }
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected void setAuthenticateHeader(HttpServletResponse response, String error, String errorMessage, Map<String, String> additionalParams) throws IOException {
        StringBuilder builder = new StringBuilder("OAuth2");
        String delim = " ";
        if (error != null) {
            builder.append(delim).append("error=\"").append(error).append("\"");
            delim = ", ";
        }
        if (errorMessage != null) {
            builder.append(delim).append("error_description=\"").append(errorMessage).append("\"");
            delim = ", ";
        }
        if (additionalParams != null) {
            for (Map.Entry<String, String> param : additionalParams.entrySet()) {
                builder.append(delim).append(param.getKey()).append("=\"").append(param.getValue()).append("\"");
                delim = ", ";
            }
        }
        response.addHeader("WWW-Authenticate", builder.toString());
    }

    protected String parseToken(HttpServletRequest request) {
        String token = this.parseHeaderToken(request);
        if (token == null) {
            token = request.getParameter("oauth_token");
        }
        return token;
    }

    protected String parseHeaderToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Authorization");
        while (headers.hasMoreElements()) {
            String authHeaderValue;
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith("oauth ") || (authHeaderValue = value.substring(6)).contains("oauth_signature_method")) continue;
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        return null;
    }

    public ThrowableAnalyzer getThrowableAnalyzer() {
        return this.throwableAnalyzer;
    }

    @Autowired(required=false)
    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public OAuth2ProviderTokenServices getTokenServices() {
        return this.tokenServices;
    }

    @Autowired
    public void setTokenServices(OAuth2ProviderTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }
}

