/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.oauth2.consumer.OAuth2ClientHttpRequestFactory;
import org.springframework.security.oauth2.consumer.OAuth2ErrorHandler;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class OAuth2RestTemplate
extends RestTemplate {
    private final OAuth2ProtectedResourceDetails resource;

    public OAuth2RestTemplate(OAuth2ProtectedResourceDetails resource) {
        this((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory(), resource);
    }

    public OAuth2RestTemplate(ClientHttpRequestFactory requestFactory, OAuth2ProtectedResourceDetails resource) {
        if (resource == null) {
            throw new IllegalArgumentException("An OAuth2 resource must be supplied.");
        }
        this.resource = resource;
        this.setRequestFactory(requestFactory);
        this.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorHandler());
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        if (!(requestFactory instanceof OAuth2ClientHttpRequestFactory)) {
            requestFactory = new OAuth2ClientHttpRequestFactory(requestFactory, this.getResource());
        }
        super.setRequestFactory(requestFactory);
    }

    public OAuth2ProtectedResourceDetails getResource() {
        return this.resource;
    }
}

