/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.consumer.AbstractOAuth2ProfileManager;
import org.springframework.security.oauth2.consumer.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.consumer.OAuth2Profile;
import org.springframework.security.oauth2.consumer.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.consumer.UserRedirectRequiredException;
import org.springframework.security.oauth2.consumer.webserver.WebServerProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2ProfileChain
extends AbstractOAuth2ProfileManager {
    private final List<OAuth2Profile> chain;

    public OAuth2ProfileChain() {
        this(Arrays.asList(new WebServerProfile()));
    }

    public OAuth2ProfileChain(List<OAuth2Profile> chain) {
        this.chain = chain == null ? Collections.emptyList() : Collections.unmodifiableList(chain);
    }

    @Override
    protected OAuth2AccessToken obtainNewAccessToken(OAuth2ProtectedResourceDetails details) throws UserRedirectRequiredException, AccessDeniedException {
        for (OAuth2Profile profile : this.chain) {
            if (!profile.supportsResource(details)) continue;
            return profile.obtainNewAccessToken(details);
        }
        throw new OAuth2AccessDeniedException("Unable to obtain a new access token for resource '" + details.getId() + "'. The profile manager is not configured to support it.", details);
    }

    public List<OAuth2Profile> getChain() {
        return this.chain;
    }
}

