/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.provider;

import java.util.Map;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth.provider.ConsumerCredentials;
import org.springframework.security.oauth.provider.ConsumerDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerAuthentication
extends AbstractAuthenticationToken {
    private final ConsumerDetails consumerDetails;
    private final ConsumerCredentials consumerCredentials;
    private final Map<String, String> oauthParameters;
    private boolean signatureValidated = false;

    public ConsumerAuthentication(ConsumerDetails consumerDetails, ConsumerCredentials consumerCredentials) {
        super(consumerDetails.getAuthorities());
        this.consumerDetails = consumerDetails;
        this.consumerCredentials = consumerCredentials;
        this.oauthParameters = null;
    }

    public ConsumerAuthentication(ConsumerDetails consumerDetails, ConsumerCredentials consumerCredentials, Map<String, String> oauthParams) {
        super(consumerDetails.getAuthorities());
        this.consumerDetails = consumerDetails;
        this.consumerCredentials = consumerCredentials;
        this.oauthParameters = oauthParams;
    }

    public Object getCredentials() {
        return this.getConsumerCredentials();
    }

    public ConsumerCredentials getConsumerCredentials() {
        return this.consumerCredentials;
    }

    public Object getPrincipal() {
        return this.getConsumerDetails();
    }

    public ConsumerDetails getConsumerDetails() {
        return this.consumerDetails;
    }

    public Map<String, String> getOAuthParameters() {
        return this.oauthParameters;
    }

    public String getName() {
        return this.getConsumerDetails() != null ? this.getConsumerDetails().getConsumerKey() : null;
    }

    public boolean isSignatureValidated() {
        return this.signatureValidated;
    }

    public void setSignatureValidated(boolean signatureValidated) {
        this.signatureValidated = signatureValidated;
    }

    public boolean isAuthenticated() {
        return this.isSignatureValidated();
    }

    public void setAuthenticated(boolean authenticated) {
        this.setSignatureValidated(authenticated);
    }
}

