/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.springframework.restdocs.config.RestDocumentationContext;
import org.springframework.restdocs.snippet.AsciidoctorWriter;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.OutputFileResolver;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public abstract class SnippetWritingResultHandler
implements ResultHandler {
    private String outputDir;
    private String fileName;

    protected SnippetWritingResultHandler(String outputDir, String fileName) {
        this.outputDir = outputDir;
        this.fileName = fileName;
    }

    protected abstract void handle(MvcResult var1, DocumentationWriter var2) throws IOException;

    public void handle(MvcResult result) throws IOException {
        try (Writer writer = this.createWriter();){
            this.handle(result, new AsciidoctorWriter(writer));
        }
    }

    private Writer createWriter() throws IOException {
        File outputFile = new OutputFileResolver().resolve(this.outputDir, this.fileName + ".adoc");
        if (outputFile != null) {
            File parent = outputFile.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new IllegalStateException("Failed to create directory '" + parent + "'");
            }
            RestDocumentationContext context = RestDocumentationContext.currentContext();
            if (context == null || context.getSnippetEncoding() == null) {
                return new FileWriter(outputFile);
            }
            return new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), context.getSnippetEncoding());
        }
        return new OutputStreamWriter(System.out);
    }
}

