/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.response;

import java.util.regex.Pattern;
import org.springframework.restdocs.response.HeaderRemovingResponsePostProcessor;
import org.springframework.restdocs.response.LinkMaskingResponsePostProcessor;
import org.springframework.restdocs.response.PatternReplacingResponsePostProcessor;
import org.springframework.restdocs.response.PrettyPrintingResponsePostProcessor;
import org.springframework.restdocs.response.ResponsePostProcessor;

public abstract class ResponsePostProcessors {
    private ResponsePostProcessors() {
    }

    public static ResponsePostProcessor prettyPrintContent() {
        return new PrettyPrintingResponsePostProcessor();
    }

    public static ResponsePostProcessor removeHeaders(String ... headerNames) {
        return new HeaderRemovingResponsePostProcessor(headerNames);
    }

    public static ResponsePostProcessor maskLinks() {
        return new LinkMaskingResponsePostProcessor();
    }

    public static ResponsePostProcessor maskLinksWith(String mask) {
        return new LinkMaskingResponsePostProcessor(mask);
    }

    public static ResponsePostProcessor replacePattern(Pattern pattern, String replacement) {
        return new PatternReplacingResponsePostProcessor(pattern, replacement);
    }
}

