/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.response;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.response.ResponsePostProcessor;
import org.springframework.util.ReflectionUtils;

public abstract class ContentModifyingReponsePostProcessor
implements ResponsePostProcessor {
    @Override
    public MockHttpServletResponse postProcess(MockHttpServletResponse response) throws Exception {
        String modifiedContent = this.modifyContent(response.getContentAsString());
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(MockHttpServletResponse.class);
        enhancer.setCallback((Callback)new ContentModifyingMethodInterceptor(modifiedContent, response));
        return (MockHttpServletResponse)enhancer.create();
    }

    protected abstract String modifyContent(String var1) throws Exception;

    private static class ContentModifyingMethodInterceptor
    implements MethodInterceptor {
        private final Method getContentAsStringMethod = ContentModifyingMethodInterceptor.findMethod("getContentAsString");
        private final Method getContentAsByteArray = ContentModifyingMethodInterceptor.findMethod("getContentAsByteArray");
        private final String modifiedContent;
        private final MockHttpServletResponse delegate;

        public ContentModifyingMethodInterceptor(String modifiedContent, MockHttpServletResponse delegate) {
            this.modifiedContent = modifiedContent;
            this.delegate = delegate;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws IllegalAccessException, InvocationTargetException {
            if (this.getContentAsStringMethod.equals(method)) {
                return this.modifiedContent;
            }
            if (this.getContentAsByteArray.equals(method)) {
                throw new UnsupportedOperationException("Following modification, the response's content should be accessed as a String");
            }
            return method.invoke((Object)this.delegate, args);
        }

        private static Method findMethod(String methodName) {
            return BridgeMethodResolver.findBridgedMethod((Method)ReflectionUtils.findMethod(MockHttpServletResponse.class, (String)methodName));
        }
    }
}

