/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class FieldPath {
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[([0-9]+|\\*){0,1}\\]");
    private final String rawPath;
    private final List<String> segments;
    private final boolean precise;

    private FieldPath(String rawPath, List<String> segments, boolean precise) {
        this.rawPath = rawPath;
        this.segments = segments;
        this.precise = precise;
    }

    boolean isPrecise() {
        return this.precise;
    }

    List<String> getSegments() {
        return this.segments;
    }

    public String toString() {
        return this.rawPath;
    }

    static FieldPath compile(String path) {
        List<String> segments = FieldPath.extractSegments(path);
        return new FieldPath(path, segments, FieldPath.matchesSingleValue(segments));
    }

    static boolean isArraySegment(String segment) {
        return ARRAY_INDEX_PATTERN.matcher(segment).matches();
    }

    static boolean matchesSingleValue(List<String> segments) {
        for (String segment : segments) {
            if (!FieldPath.isArraySegment(segment)) continue;
            return false;
        }
        return true;
    }

    private static List<String> extractSegments(String path) {
        String[] stringArray;
        String processedPath;
        Matcher matcher = ARRAY_INDEX_PATTERN.matcher(path);
        StringBuilder buffer = new StringBuilder();
        int previous = 0;
        while (matcher.find()) {
            FieldPath.appendWithSeparatorIfNecessary(buffer, path.substring(previous, matcher.start(0)));
            FieldPath.appendWithSeparatorIfNecessary(buffer, matcher.group());
            previous = matcher.end(0);
        }
        if (previous < path.length()) {
            FieldPath.appendWithSeparatorIfNecessary(buffer, path.substring(previous));
        }
        if ((processedPath = buffer.toString()).indexOf(46) > -1) {
            stringArray = processedPath.split("\\.");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = processedPath;
        }
        return Arrays.asList(stringArray);
    }

    private static void appendWithSeparatorIfNecessary(StringBuilder buffer, String toAppend) {
        if (buffer.length() > 0 && buffer.lastIndexOf(".") != buffer.length() - 1 && !toAppend.startsWith(".")) {
            buffer.append(".");
        }
        buffer.append(toAppend);
    }
}

