/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.config;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

public final class RestDocumentationContext {
    private static final ThreadLocal<RestDocumentationContext> CONTEXTS = new InheritableThreadLocal<RestDocumentationContext>();
    private final AtomicInteger stepCount = new AtomicInteger(0);
    private final Method testMethod;
    private String snippetEncoding;

    private RestDocumentationContext() {
        this(null);
    }

    private RestDocumentationContext(Method testMethod) {
        this.testMethod = testMethod;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    int getAndIncrementStepCount() {
        return this.stepCount.getAndIncrement();
    }

    public int getStepCount() {
        return this.stepCount.get();
    }

    void setSnippetEncoding(String snippetEncoding) {
        this.snippetEncoding = snippetEncoding;
    }

    public String getSnippetEncoding() {
        return this.snippetEncoding;
    }

    static void establishContext(Method testMethod) {
        CONTEXTS.set(new RestDocumentationContext(testMethod));
    }

    static void clearContext() {
        CONTEXTS.set(null);
    }

    public static RestDocumentationContext currentContext() {
        return CONTEXTS.get();
    }
}

