/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.internal.logging;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongPredicate;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

class EveryNthSampler<T> {
    private final long nth;
    private final long maxInputs;
    private final Map<T, AtomicLong> inputCounters = new ConcurrentHashMap<T, AtomicLong>();
    private final AtomicLong numInputCounters = new AtomicLong(0L);
    private final LogAccessor logger = new LogAccessor(EveryNthSampler.class);

    EveryNthSampler(long nth, long maxInputs) {
        Assert.state((nth > 0L ? 1 : 0) != 0, () -> "nth must be a positive value");
        Assert.state((maxInputs > 0L ? 1 : 0) != 0, () -> "maxInputs must be a positive value");
        this.nth = nth;
        this.maxInputs = maxInputs;
    }

    boolean trySample(T input) {
        AtomicLong initialCounter = new AtomicLong(0L);
        AtomicLong inputCounter = this.inputCounters.computeIfAbsent(input, __ -> initialCounter);
        if (inputCounter == initialCounter) {
            this.incrementWithResetAtThreshold(this.numInputCounters, this.maxInputs + 1L, this.maxInputs::equals, () -> CompletableFuture.runAsync(() -> {
                this.logger.debug(() -> "Max inputs (%s) reached - clearing map".formatted(this.maxInputs));
                this.inputCounters.clear();
                this.inputCounters.computeIfAbsent(input, __ -> initialCounter);
            }));
        }
        AtomicBoolean sampled = new AtomicBoolean(false);
        this.incrementWithResetAtThreshold(inputCounter, this.nth, 0L::equals, () -> {
            this.logger.trace(() -> "Input [%s] is sampled".formatted(input));
            sampled.set(true);
        });
        return sampled.get();
    }

    private void incrementWithResetAtThreshold(AtomicLong counter, long threshold, LongPredicate runActionIfPriorCountMeets, Runnable action) {
        long priorCount = this.incrementWithResetAtThreshold(counter, threshold);
        if (runActionIfPriorCountMeets.test(priorCount)) {
            action.run();
        }
    }

    private long incrementWithResetAtThreshold(AtomicLong counter, long threshold) {
        return counter.getAndUpdate(currentCount -> (currentCount + 1L) % threshold == 0L ? 0L : currentCount + 1L);
    }
}

