/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaDefinitionBuilder;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.SchemaDefinitionBuilderImpl;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public interface JSONSchemaUtil {
    public static <T> JSONSchema<T> schemaForTypeWithObjectMapper(Class<T> objectType, ObjectMapper objectMapper) {
        return JSONSchemaUtil.schemaForTypeWithObjectMapper(objectType, objectMapper, b -> {});
    }

    public static <T> JSONSchema<T> schemaForTypeWithObjectMapper(Class<T> objectType, ObjectMapper objectMapper, Consumer<SchemaDefinitionBuilder<T>> schemaDefinitionBuilderCustomizer) {
        CustomJacksonJsonReader<T> reader = new CustomJacksonJsonReader<T>(objectMapper, objectType);
        CustomJacksonJsonWriter writer = new CustomJacksonJsonWriter(objectMapper);
        SchemaDefinitionBuilder schemaDefinitionBuilder = new SchemaDefinitionBuilderImpl().withPojo(objectType).withSchemaReader(reader).withSchemaWriter(writer);
        schemaDefinitionBuilderCustomizer.accept(schemaDefinitionBuilder);
        return JSONSchema.of((SchemaDefinition)schemaDefinitionBuilder.build());
    }

    public static class CustomJacksonJsonReader<T>
    implements SchemaReader<T> {
        private static final LogAccessor LOG = new LogAccessor(CustomJacksonJsonReader.class);
        private final ObjectReader objectReader;
        private final Class<T> objectType;

        CustomJacksonJsonReader(ObjectMapper objectMapper, Class<T> objectType) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
            Assert.notNull(objectType, (String)"objectType must not be null");
            this.objectReader = objectMapper.readerFor(objectType);
            this.objectType = objectType;
        }

        public T read(byte[] bytes, int offset, int length) {
            try {
                return (T)this.objectReader.readValue(bytes, offset, length);
            }
            catch (IOException e) {
                throw new SchemaSerializationException((Throwable)e);
            }
        }

        public T read(InputStream inputStream) {
            try {
                Object object = this.objectReader.readValue(inputStream, this.objectType);
                return (T)object;
            }
            catch (IOException e) {
                throw new SchemaSerializationException((Throwable)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e, () -> "Failed to close input stream on read");
                }
            }
        }
    }

    public static class CustomJacksonJsonWriter<T>
    implements SchemaWriter<T> {
        private final ObjectMapper objectMapper;

        CustomJacksonJsonWriter(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
            this.objectMapper = objectMapper;
        }

        public byte[] write(T message) {
            try {
                return this.objectMapper.writeValueAsBytes(message);
            }
            catch (JsonProcessingException e) {
                throw new SchemaSerializationException((Throwable)e);
            }
        }
    }
}

