/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.config.ListenerContainerFactory;
import org.springframework.pulsar.config.ListenerEndpoint;
import org.springframework.pulsar.listener.MessageListenerContainer;
import org.springframework.pulsar.listener.PulsarListenerContainerRegistry;
import org.springframework.util.Assert;

public class GenericListenerEndpointRegistry<C extends MessageListenerContainer, E extends ListenerEndpoint<C>>
implements PulsarListenerContainerRegistry,
DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private final Class<? extends C> type;
    private final Map<String, C> listenerContainers = new ConcurrentHashMap<String, C>();
    private final ReentrantLock containersLock = new ReentrantLock();
    private ConfigurableApplicationContext applicationContext;
    private int phase = Integer.MAX_VALUE;
    private boolean contextRefreshed;
    private volatile boolean running;

    protected GenericListenerEndpointRegistry(Class<?> type) {
        this.type = type;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    @Nullable
    public C getListenerContainer(String id) {
        Assert.hasText((String)id, (String)"Container identifier must not be empty");
        return (C)((MessageListenerContainer)this.listenerContainers.get(id));
    }

    @Override
    public Set<String> getListenerContainerIds() {
        return Collections.unmodifiableSet(this.listenerContainers.keySet());
    }

    public Collection<C> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    public Collection<C> getAllListenerContainers() {
        ArrayList<C> containers = new ArrayList<C>(this.getListenerContainers());
        containers.addAll(this.applicationContext.getBeansOfType(this.type, true, false).values());
        return containers;
    }

    public void registerListenerContainer(E endpoint, ListenerContainerFactory<? extends C, E> factory) {
        this.registerListenerContainer(endpoint, factory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerContainer(E endpoint, ListenerContainerFactory<? extends C, E> factory, boolean startImmediately) {
        Assert.notNull(endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must not be empty");
        this.containersLock.lock();
        try {
            Assert.state((!this.listenerContainers.containsKey(id) ? 1 : 0) != 0, (String)("Another endpoint is already registered with id '" + id + "'"));
            C container = this.createListenerContainer(endpoint, factory);
            this.listenerContainers.put(id, container);
        }
        finally {
            this.containersLock.unlock();
        }
    }

    protected C createListenerContainer(E endpoint, ListenerContainerFactory<? extends C, E> factory) {
        MessageListenerContainer listenerContainer = (MessageListenerContainer)factory.createRegisteredContainer(endpoint);
        if (listenerContainer instanceof InitializingBean) {
            try {
                ((InitializingBean)listenerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        int containerPhase = listenerContainer.getPhase();
        if (listenerContainer.isAutoStartup() && containerPhase != Integer.MAX_VALUE) {
            if (this.phase != Integer.MAX_VALUE && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = listenerContainer.getPhase();
        }
        return (C)listenerContainer;
    }

    public void destroy() throws Exception {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.destroy();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            this.startIfNecessary(listenerContainer);
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        this.running = false;
        Collection<C> listenerContainersToStop = this.getListenerContainers();
        if (listenerContainersToStop.size() > 0) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(listenerContainersToStop.size(), callback);
            for (MessageListenerContainer listenerContainer : listenerContainersToStop) {
                if (listenerContainer.isRunning()) {
                    listenerContainer.stop(aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.applicationContext)) {
            this.contextRefreshed = true;
        }
    }

    private void startIfNecessary(C listenerContainer) {
        if (this.contextRefreshed || listenerContainer.isAutoStartup()) {
            listenerContainer.start();
        }
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        private AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() <= 0) {
                this.finishCallback.run();
            }
        }
    }
}

