/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.tomcat;

import org.apache.catalina.Context;
import org.osgi.framework.Bundle;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.deployer.WarDeploymentContext;
import org.springframework.osgi.web.deployer.internal.support.DefaultWarDeploymentContext;
import org.springframework.osgi.web.deployer.tomcat.TomcatContextUndeployer;

class TomcatWarDeployment
implements WarDeployment {
    private boolean active = true;
    private final Context catalinaContext;
    private final TomcatContextUndeployer undeployer;
    private final WarDeploymentContext deploymentContext;

    TomcatWarDeployment(TomcatContextUndeployer undeployer, Bundle bundle, Context catalinaContext) {
        this.undeployer = undeployer;
        this.catalinaContext = catalinaContext;
        this.deploymentContext = new DefaultWarDeploymentContext(bundle, catalinaContext.getPath(), catalinaContext.getServletContext());
    }

    public WarDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void undeploy() throws OsgiWarDeploymentException {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.undeployer.undeploy(this.catalinaContext);
    }

    Context getCatalinaContext() {
        return this.catalinaContext;
    }
}

