/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.provisioning.internal;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.provisioning.ArtifactLocator;
import org.springframework.osgi.test.provisioning.internal.MavenPackagedArtifactFinder;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LocalFileSystemMavenRepository
implements ArtifactLocator {
    private static final char SLASH_CHAR = '/';
    private static final String LOCAL_REPOSITORY_ELEM = "localRepository";
    private static final Log log = LogFactory.getLog(LocalFileSystemMavenRepository.class);
    private static final String SYS_PROPERTY = "localRepository";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String M2_DIR = ".m2";
    private static final String M2_SETTINGS = ".m2".concat("/settings.xml");
    private static final String DEFAULT_DIR = ".m2".concat("/repository");
    private String repositoryHome;

    private void init() {
        if (this.repositoryHome != null) {
            return;
        }
        boolean trace = log.isDebugEnabled();
        final String[] sysProperties = new String[2];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sysProperties[0] = System.getProperty("localRepository");
                sysProperties[1] = System.getProperty(LocalFileSystemMavenRepository.USER_HOME_PROPERTY);
                return null;
            }
        });
        String localRepository = sysProperties[0];
        String userHome = sysProperties[1];
        if (trace) {
            log.trace((Object)("M2 system property [localRepository] has value=" + localRepository));
        }
        if (localRepository == null) {
            FileSystemResource settingsFile = new FileSystemResource(new File(userHome, M2_SETTINGS));
            localRepository = this.getMavenSettingsLocalRepository((Resource)settingsFile);
            if (trace) {
                log.trace((Object)("Falling back to M2 settings.xml [" + settingsFile + "]; found value=" + localRepository));
            }
            if (localRepository == null) {
                localRepository = new File(userHome, DEFAULT_DIR).getAbsolutePath();
                if (trace) {
                    log.trace((Object)("No custom setting found; using default M2 local repository=" + localRepository));
                }
            }
        }
        this.repositoryHome = localRepository;
        log.info((Object)("Local Maven2 repository used: [" + this.repositoryHome + "]"));
    }

    String getMavenSettingsLocalRepository(Resource m2Settings) {
        if (!m2Settings.exists()) {
            return null;
        }
        try {
            DefaultDocumentLoader docLoader = new DefaultDocumentLoader();
            Document document = docLoader.loadDocument(new InputSource(m2Settings.getInputStream()), null, null, 0, false);
            return DomUtils.getChildElementValueByTagName((Element)document.getDocumentElement(), (String)"localRepository");
        }
        catch (Exception ex) {
            throw new RuntimeException(new ParserConfigurationException("error parsing resource=" + m2Settings).initCause(ex));
        }
    }

    public Resource locateArtifact(String groupId, String artifactId, String version) {
        return this.locateArtifact(groupId, artifactId, version, "jar");
    }

    public Resource locateArtifact(final String groupId, final String artifactId, final String version, final String type) {
        this.init();
        return (Resource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return LocalFileSystemMavenRepository.this.localMavenBuildArtifact(groupId, artifactId, version, type);
                }
                catch (IllegalStateException illStateEx) {
                    Resource localMavenBundle = LocalFileSystemMavenRepository.this.localMavenBundle(groupId, artifactId, version, type);
                    if (log.isDebugEnabled()) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("[");
                        buf.append(groupId);
                        buf.append("|");
                        buf.append(artifactId);
                        buf.append("|");
                        buf.append(version);
                        buf.append("]");
                        log.debug((Object)(buf + " local maven build artifact detection failed, falling back to local maven bundle " + localMavenBundle.getDescription()));
                    }
                    return localMavenBundle;
                }
            }
        });
    }

    protected Resource localMavenBundle(String groupId, String artifact, String version, String type) {
        StringBuilder location = new StringBuilder(groupId.replace('.', '/'));
        location.append('/');
        location.append(artifact);
        location.append('/');
        location.append(version);
        location.append('/');
        location.append(artifact);
        location.append('-');
        location.append(version);
        location.append(".");
        location.append(type);
        return new FileSystemResource(new File(this.repositoryHome, location.toString()));
    }

    protected Resource localMavenBuildArtifact(String groupId, String artifactId, String version, String type) {
        try {
            File found = new MavenPackagedArtifactFinder(groupId, artifactId, version, type).findPackagedArtifact(new File("."));
            FileSystemResource res = new FileSystemResource(found);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + artifactId + "|" + version + "] resolved to " + res.getDescription() + " as a local maven artifact"));
            }
            return res;
        }
        catch (IOException ioEx) {
            throw (RuntimeException)new IllegalStateException("Artifact " + artifactId + "-" + version + "." + type + " could not be found").initCause(ioEx);
        }
    }
}

