/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test;

import java.util.Hashtable;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.test.internal.OsgiJUnitTest;
import org.springframework.osgi.test.internal.TestRunnerService;
import org.springframework.osgi.test.internal.holder.HolderLoader;
import org.springframework.osgi.test.internal.holder.OsgiTestInfoHolder;
import org.springframework.osgi.test.internal.support.OsgiJUnitTestAdapter;
import org.springframework.osgi.util.OsgiServiceUtils;

public class JUnitTestActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(JUnitTestActivator.class);
    private BundleContext context;
    private ServiceReference reference;
    private ServiceRegistration registration;
    private TestRunnerService service;

    public void start(BundleContext bc) throws Exception {
        this.context = bc;
        this.reference = this.context.getServiceReference(TestRunnerService.class.getName());
        if (this.reference == null) {
            throw new IllegalArgumentException("cannot find service at " + TestRunnerService.class.getName());
        }
        this.service = (TestRunnerService)this.context.getService(this.reference);
        this.registration = this.context.registerService(JUnitTestActivator.class.getName(), (Object)this, new Hashtable());
    }

    void executeTest() {
        this.service.runTest(this.loadTest());
    }

    private OsgiJUnitTest loadTest() {
        OsgiTestInfoHolder holder = HolderLoader.INSTANCE.getHolder();
        String testClass = holder.getTestClassName();
        if (testClass == null) {
            throw new IllegalArgumentException("no test class specified");
        }
        try {
            Class clazz = this.context.getBundle().loadClass(testClass);
            TestCase test = (TestCase)clazz.newInstance();
            OsgiJUnitTestAdapter osgiTest = new OsgiJUnitTestAdapter(test);
            osgiTest.injectBundleContext(this.context);
            return osgiTest;
        }
        catch (Exception ex) {
            log.error((Object)"failed to invoke test execution", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void stop(BundleContext bc) throws Exception {
        OsgiServiceUtils.unregisterService((ServiceRegistration)this.registration);
    }
}

