/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.AbstractDependencyManagerTests;
import org.springframework.osgi.test.JUnitTestActivator;
import org.springframework.osgi.test.internal.util.DependencyVisitor;
import org.springframework.osgi.test.internal.util.jar.JarCreator;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractOnTheFlyBundleCreatorTests
extends AbstractDependencyManagerTests {
    private static final String META_INF_JAR_LOCATION = "/META-INF/MANIFEST.MF";
    JarCreator jarCreator;
    private Map jarEntries;
    private Manifest manifest;

    public AbstractOnTheFlyBundleCreatorTests() {
        this.initializeJarCreator();
    }

    public AbstractOnTheFlyBundleCreatorTests(String testName) {
        super(testName);
        this.initializeJarCreator();
    }

    private void initializeJarCreator() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AbstractOnTheFlyBundleCreatorTests.this.jarCreator = new JarCreator();
                return null;
            }
        });
    }

    protected String getRootPath() {
        return "file:./target/test-classes/";
    }

    protected String[] getBundleContentPattern() {
        return new String[]{"/**/*"};
    }

    protected String getManifestLocation() {
        return null;
    }

    protected Manifest getManifest() {
        if (this.manifest != null) {
            return this.manifest;
        }
        String manifestLocation = this.getManifestLocation();
        if (StringUtils.hasText((String)manifestLocation)) {
            this.logger.info((Object)("Using Manifest from specified location=[" + this.getManifestLocation() + "]"));
            DefaultResourceLoader loader = new DefaultResourceLoader();
            this.manifest = this.createManifestFrom(loader.getResource(manifestLocation));
        } else {
            this.jarCreator.setRootPath(this.getRootPath());
            this.jarCreator.setContentPattern(this.getBundleContentPattern());
            this.jarEntries = this.jarCreator.resolveContent();
            Iterator iterator = this.jarEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!META_INF_JAR_LOCATION.equals(entry.getKey())) continue;
                this.logger.info((Object)"Using Manifest from the test bundle content=[/META-INF/MANIFEST.MF]");
                this.manifest = this.createManifestFrom((Resource)entry.getValue());
            }
            if (this.manifest == null) {
                this.logger.info((Object)"Automatically creating Manifest for the test bundle");
                this.manifest = this.createDefaultManifest();
            }
        }
        return this.manifest;
    }

    protected boolean createManifestOnlyFromTestClass() {
        return true;
    }

    private Manifest createManifestFrom(Resource resource) {
        Assert.notNull((Object)resource, (String)"unable to create manifest for empty resources");
        try {
            return new Manifest(resource.getInputStream());
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalArgumentException("cannot create manifest from " + resource).initCause(ex);
        }
    }

    protected Manifest createDefaultManifest() {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.putValue("Bundle-ManifestVersion", "2");
        String description = this.getName() + "-" + ((Object)((Object)this)).getClass().getName();
        attrs.putValue("Bundle-Name", "TestBundle-" + description);
        attrs.putValue("Bundle-SymbolicName", "TestBundle-" + description);
        attrs.putValue("Bundle-Description", "on-the-fly test bundle");
        attrs.putValue("Bundle-Activator", JUnitTestActivator.class.getName());
        this.addImportPackage(manifest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created manifest:" + manifest.getMainAttributes().entrySet()));
        }
        return manifest;
    }

    private void addImportPackage(Manifest manifest) {
        Object[] rawImports = this.determineImports();
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)("Discovered raw imports " + ObjectUtils.nullSafeToString((Object[])rawImports)));
        }
        Collection specialImportsOut = this.eliminateSpecialPackages((String[])rawImports);
        Collection imports = this.eliminatePackagesAvailableInTheJar(specialImportsOut);
        if (trace) {
            this.logger.trace((Object)("Filtered imports are " + imports));
        }
        manifest.getMainAttributes().putValue("Import-Package", StringUtils.collectionToCommaDelimitedString((Collection)imports));
    }

    private Collection eliminateSpecialPackages(String[] rawImports) {
        String currentPckg = ClassUtils.classPackageAsResourcePath(((Object)((Object)this)).getClass()).replace('/', '.');
        LinkedHashSet<String> filteredImports = new LinkedHashSet<String>(rawImports.length);
        LinkedHashSet<String> eliminatedImports = new LinkedHashSet<String>(4);
        for (int i = 0; i < rawImports.length; ++i) {
            String pckg = rawImports[i];
            if (!(pckg.startsWith("java.") || pckg.startsWith("org.springframework.osgi.test.internal") || pckg.equals(currentPckg))) {
                filteredImports.add(pckg);
                continue;
            }
            eliminatedImports.add(pckg);
        }
        if (!eliminatedImports.isEmpty() && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Eliminated special packages " + eliminatedImports));
        }
        return filteredImports;
    }

    private Collection eliminatePackagesAvailableInTheJar(Collection imports) {
        if (this.jarEntries == null || this.jarEntries.isEmpty()) {
            return imports;
        }
        LinkedHashSet<String> filteredImports = new LinkedHashSet<String>(imports.size());
        LinkedHashSet<String> eliminatedImports = new LinkedHashSet<String>(2);
        Collection jarPackages = this.jarCreator.getContainedPackages();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String pckg = (String)iterator.next();
            if (jarPackages.contains(pckg)) {
                eliminatedImports.add(pckg);
                continue;
            }
            filteredImports.add(pckg);
        }
        if (!eliminatedImports.isEmpty() && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Eliminated packages already present in the bundle " + eliminatedImports));
        }
        return filteredImports;
    }

    private String[] determineImports() {
        LinkedHashMap<String, InputStreamResource> entries;
        boolean useTestClassOnly = false;
        if (this.jarEntries == null || this.jarEntries.isEmpty()) {
            this.logger.debug((Object)"No test jar content detected, generating bundle imports from the test class");
            useTestClassOnly = true;
        } else if (this.createManifestOnlyFromTestClass()) {
            this.logger.info((Object)"Using the test class for generating bundle imports");
            useTestClassOnly = true;
        } else {
            this.logger.info((Object)"Using all classes in the jar for the generation of bundle imports");
        }
        if (useTestClassOnly) {
            entries = new LinkedHashMap<String, InputStreamResource>(4);
            Class<?> clazz = ((Object)((Object)this)).getClass();
            String clazzPackage = null;
            String endPackage = AbstractOnTheFlyBundleCreatorTests.class.getPackage().getName();
            do {
                ArrayList classes = new ArrayList(4);
                classes.add(clazz);
                CollectionUtils.mergeArrayIntoCollection(clazz.getDeclaredClasses(), classes);
                Iterator iterator = classes.iterator();
                while (iterator.hasNext()) {
                    Class classToInspect = (Class)iterator.next();
                    Package pkg = classToInspect.getPackage();
                    if (pkg != null) {
                        clazzPackage = pkg.getName();
                        String classFile = ClassUtils.getClassFileName((Class)classToInspect);
                        entries.put(classToInspect.getName().replace('.', '/').concat(".class"), new InputStreamResource(classToInspect.getResourceAsStream(classFile)));
                        continue;
                    }
                    this.logger.warn((Object)("Could not find package for class " + classToInspect + "; ignoring..."));
                }
                clazz = clazz.getSuperclass();
            } while (!endPackage.equals(clazzPackage));
        } else {
            entries = this.jarEntries;
        }
        return this.determineImportsFor(entries);
    }

    private String[] determineImportsFor(Map entries) {
        Collection containedPackages = this.jarCreator.getContainedPackages();
        LinkedHashSet<String> cumulatedPackages = new LinkedHashSet<String>();
        boolean validPackageCollection = !containedPackages.isEmpty();
        boolean trace = this.logger.isTraceEnabled();
        Iterator iterator = entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String resourceName = (String)entry.getKey();
            if (!resourceName.endsWith(".class")) continue;
            if (trace) {
                this.logger.trace((Object)("Analyze imports for test bundle resource " + resourceName));
            }
            String classFileName = StringUtils.getFilename((String)resourceName);
            String className = classFileName.substring(0, classFileName.length() - ".class".length());
            String classPkg = resourceName.substring(0, resourceName.length() - classFileName.length()).replace('/', '.');
            if (classPkg.startsWith(".")) {
                classPkg = classPkg.substring(1);
            }
            if (classPkg.endsWith(".")) {
                classPkg = classPkg.substring(0, classPkg.length() - 1);
            }
            if (validPackageCollection && StringUtils.hasText((String)classPkg) && !containedPackages.contains(classPkg)) {
                this.logger.trace((Object)("Package [" + classPkg + "] is NOT part of the test archive; adding an import for it"));
                cumulatedPackages.add(classPkg);
                continue;
            }
            if (trace) {
                this.logger.trace((Object)("Package [" + classPkg + "] is part of the test archive; parsing " + className + " bytecode to determine imports..."));
            }
            cumulatedPackages.addAll(this.determineImportsForClass(className, (Resource)entry.getValue()));
        }
        return cumulatedPackages.toArray(new String[cumulatedPackages.size()]);
    }

    private Set determineImportsForClass(String className, Resource resource) {
        ClassReader reader;
        Assert.notNull((Object)resource, (String)"a not-null class is required");
        DependencyVisitor visitor = new DependencyVisitor();
        boolean trace = this.logger.isTraceEnabled();
        try {
            if (trace) {
                this.logger.trace((Object)("Visiting class " + className));
            }
            reader = new ClassReader(resource.getInputStream());
        }
        catch (Exception ex) {
            throw (RuntimeException)new IllegalArgumentException("Cannot read class " + className).initCause(ex);
        }
        reader.accept((ClassVisitor)visitor, false);
        Set originalPackages = visitor.getPackages();
        LinkedHashSet<String> pkgs = new LinkedHashSet<String>(originalPackages.size());
        Iterator iterator = originalPackages.iterator();
        while (iterator.hasNext()) {
            String pkg = (String)iterator.next();
            pkgs.add(pkg.replace('/', '.'));
        }
        return pkgs;
    }

    protected void postProcessBundleContext(BundleContext context) throws Exception {
        Resource jar;
        this.logger.debug((Object)"Post processing: creating test bundle");
        Manifest mf = this.getManifest();
        if (this.jarEntries == null) {
            this.jarCreator.setRootPath(this.getRootPath());
            this.jarCreator.setContentPattern(this.getBundleContentPattern());
            jar = this.jarCreator.createJar(mf);
        } else {
            jar = this.jarCreator.createJar(mf, this.jarEntries);
        }
        try {
            this.installAndStartBundle(context, jar);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to dynamically start generated unit test bundle");
            ise.initCause(e);
            throw ise;
        }
        super.postProcessBundleContext(context);
    }

    private void installAndStartBundle(BundleContext context, Resource resource) throws Exception {
        Bundle bundle = context.installBundle("[onTheFly-test-bundle]" + ClassUtils.getShortName(((Object)((Object)this)).getClass()) + "[" + ((Object)((Object)this)).hashCode() + "]", resource.getInputStream());
        String bundleString = OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle);
        boolean debug = this.logger.isDebugEnabled();
        if (debug) {
            this.logger.debug((Object)("Test bundle [" + bundleString + "] succesfully installed"));
        }
        bundle.start();
        if (debug) {
            this.logger.debug((Object)("Test bundle [" + bundleString + "] succesfully started"));
        }
    }
}

