/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.OsgiStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyBundleRegistry<T> {
    private final Log log;
    private final ConcurrentMap<Bundle, T> activeBundles = new ConcurrentHashMap<Bundle, T>(8);
    private final ConcurrentMap<Bundle, Boolean> lazyBundles = new ConcurrentHashMap<Bundle, Boolean>(8);
    private final List<Bundle> promotionQueue = new ArrayList<Bundle>(4);
    private volatile AtomicInteger threadCounter = new AtomicInteger();
    private final Condition condition;
    private final Activator<T> activator;

    LazyBundleRegistry(Condition promotionCondition, Activator<T> activator, Log log) {
        this.condition = promotionCondition;
        this.activator = activator;
        this.log = log;
    }

    void add(Bundle bundle, boolean isLazy, boolean applyCondition) {
        if (isLazy) {
            this.lazyBundles.put(bundle, applyCondition);
        } else {
            this.activeBundles.put(bundle, this.activator.activate(bundle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Bundle bundle) {
        boolean value = false;
        value = this.activeBundles.remove(bundle) != null;
        value |= this.lazyBundles.remove(bundle) != null;
        List<Bundle> list = this.promotionQueue;
        synchronized (list) {
        }
        return value |= this.promotionQueue.remove(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <V> V apply(Operation<T, V> action) throws Exception {
        V v;
        boolean debug;
        block33: {
            V v2;
            block32: {
                List<Bundle> list;
                Bundle[] loggedBundles2;
                V v3;
                block31: {
                    debug = this.log.isDebugEnabled();
                    this.threadCounter.incrementAndGet();
                    try {
                        for (Object v4 : this.activeBundles.values()) {
                            V value = action.operate(v4);
                            if (value == null) continue;
                            v3 = value;
                            Object var11_10 = null;
                            loggedBundles2 = null;
                            list = this.promotionQueue;
                            break block31;
                        }
                        for (Map.Entry entry : this.lazyBundles.entrySet()) {
                            Bundle bundle = (Bundle)entry.getKey();
                            Boolean applyCondition = (Boolean)entry.getValue();
                            if (Boolean.FALSE.equals(applyCondition) || Boolean.TRUE.equals(applyCondition) && this.condition.pass(bundle)) {
                                V value;
                                Object result = this.activeBundles.putIfAbsent(bundle, this.activator.activate(bundle));
                                if (result == null) {
                                    result = this.activeBundles.get(bundle);
                                    List<Bundle> list2 = this.promotionQueue;
                                    synchronized (list2) {
                                        this.promotionQueue.add(bundle);
                                    }
                                }
                                if (result == null || (value = action.operate(result)) == null) continue;
                                v2 = value;
                                break block32;
                            }
                            this.lazyBundles.remove(bundle);
                            if (!debug) continue;
                            this.log.debug((Object)("Activated lazy bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + " but found it unsuitable"));
                        }
                        v = null;
                        break block33;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        Bundle[] loggedBundles2 = null;
                        List<Bundle> list3 = this.promotionQueue;
                        synchronized (list3) {
                            if (this.threadCounter.decrementAndGet() == 0) {
                                for (Bundle bundle : this.promotionQueue) {
                                    if (this.lazyBundles.remove(bundle) != null) continue;
                                    this.activeBundles.remove(bundle);
                                }
                            }
                            if (debug && !this.promotionQueue.isEmpty()) {
                                loggedBundles2 = this.promotionQueue.toArray(new Bundle[this.promotionQueue.size()]);
                            }
                            this.promotionQueue.clear();
                        }
                        if (loggedBundles2 == null) throw throwable;
                        StringBuilder builder = new StringBuilder("Activated (and validated) lazy bundles [ ");
                        Bundle[] arr$ = loggedBundles2;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) {
                                builder.append("]");
                                this.log.debug((Object)builder);
                                throw throwable;
                            }
                            Bundle bundle = arr$[i$];
                            builder.append(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle));
                            builder.append(" ");
                            ++i$;
                        }
                    }
                }
                synchronized (list) {
                    if (this.threadCounter.decrementAndGet() == 0) {
                        for (Bundle bundle : this.promotionQueue) {
                            if (this.lazyBundles.remove(bundle) != null) continue;
                            this.activeBundles.remove(bundle);
                        }
                    }
                    if (debug && !this.promotionQueue.isEmpty()) {
                        loggedBundles2 = this.promotionQueue.toArray(new Bundle[this.promotionQueue.size()]);
                    }
                    this.promotionQueue.clear();
                }
                if (loggedBundles2 == null) return v3;
                StringBuilder builder = new StringBuilder("Activated (and validated) lazy bundles [ ");
                for (Bundle bundle : loggedBundles2) {
                    builder.append(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle));
                    builder.append(" ");
                }
                builder.append("]");
                this.log.debug((Object)builder);
                return v3;
            }
            Object var11_11 = null;
            Bundle[] loggedBundles2 = null;
            List<Bundle> list = this.promotionQueue;
            synchronized (list) {
                if (this.threadCounter.decrementAndGet() == 0) {
                    for (Bundle bundle : this.promotionQueue) {
                        if (this.lazyBundles.remove(bundle) != null) continue;
                        this.activeBundles.remove(bundle);
                    }
                }
                if (debug && !this.promotionQueue.isEmpty()) {
                    loggedBundles2 = this.promotionQueue.toArray(new Bundle[this.promotionQueue.size()]);
                }
                this.promotionQueue.clear();
            }
            if (loggedBundles2 == null) return v2;
            StringBuilder builder = new StringBuilder("Activated (and validated) lazy bundles [ ");
            for (Bundle bundle : loggedBundles2) {
                builder.append(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle));
                builder.append(" ");
            }
            builder.append("]");
            this.log.debug((Object)builder);
            return v2;
        }
        Object var11_12 = null;
        Bundle[] loggedBundles2 = null;
        List<Bundle> list = this.promotionQueue;
        synchronized (list) {
            if (this.threadCounter.decrementAndGet() == 0) {
                for (Bundle bundle : this.promotionQueue) {
                    if (this.lazyBundles.remove(bundle) != null) continue;
                    this.activeBundles.remove(bundle);
                }
            }
            if (debug && !this.promotionQueue.isEmpty()) {
                loggedBundles2 = this.promotionQueue.toArray(new Bundle[this.promotionQueue.size()]);
            }
            this.promotionQueue.clear();
        }
        if (loggedBundles2 == null) return v;
        StringBuilder builder = new StringBuilder("Activated (and validated) lazy bundles [ ");
        Bundle[] arr$ = loggedBundles2;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                builder.append("]");
                this.log.debug((Object)builder);
                return v;
            }
            Bundle bundle = arr$[i$];
            builder.append(OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle));
            builder.append(" ");
            ++i$;
        }
    }

    public void clear() {
        this.promotionQueue.clear();
        this.lazyBundles.clear();
        this.activeBundles.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Operation<T, V> {
        public V operate(T var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Activator<V> {
        public V activate(Bundle var1);
    }

    static interface Condition {
        public boolean pass(Bundle var1);
    }
}

