/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.dependencies.shutdown;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;
import org.springframework.util.ObjectUtils;

public class BundleDependencyComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = -108354908478230663L;
    private static final Log log = LogFactory.getLog(BundleDependencyComparator.class);

    public static boolean isSpringManagedService(ServiceReference reference) {
        if (reference == null) {
            return false;
        }
        return reference.getProperty("org.springframework.osgi.bean.name") != null || reference.getProperty("org.springframework.context.service.name") != null;
    }

    private static ServiceReference[] excludeNonSpringManagedServices(ServiceReference[] references) {
        if (ObjectUtils.isEmpty((Object[])references)) {
            return references;
        }
        int count = 0;
        for (int i = 0; i < references.length; ++i) {
            if (!BundleDependencyComparator.isSpringManagedService(references[i])) {
                references[i] = null;
                continue;
            }
            ++count;
        }
        if (count == references.length) {
            return references;
        }
        ServiceReference[] refs = new ServiceReference[count];
        int j = 0;
        for (int i = 0; i < references.length; ++i) {
            if (references[i] == null) continue;
            refs[j] = references[i];
            ++j;
        }
        return refs;
    }

    protected static int compareUsingServiceRankingAndId(Bundle a, Bundle b) {
        long bMaxId;
        int bRank;
        Object[] aservices = BundleDependencyComparator.excludeNonSpringManagedServices(a.getRegisteredServices());
        Object[] bservices = BundleDependencyComparator.excludeNonSpringManagedServices(b.getRegisteredServices());
        boolean trace = log.isTraceEnabled();
        if (ObjectUtils.isEmpty((Object[])aservices) && ObjectUtils.isEmpty((Object[])bservices)) {
            if (trace) {
                log.trace((Object)"both services have 0 services; sorting based on id");
            }
            return BundleDependencyComparator.signum((int)(a.getBundleId() - b.getBundleId()));
        }
        if (aservices == null) {
            return -1;
        }
        if (bservices == null) {
            return 1;
        }
        int aRank = BundleDependencyComparator.findHighestServiceRanking((ServiceReference[])aservices);
        if (aRank != (bRank = BundleDependencyComparator.findHighestServiceRanking((ServiceReference[])bservices))) {
            int compare = -(bRank - aRank);
            if (trace) {
                int min = compare > 0 ? bRank : aRank;
                log.trace((Object)("sorting based on lowest-service-ranking won by bundle" + (compare > 0 ? "1" : "2") + " w/ service id " + min));
            }
            return BundleDependencyComparator.signum(-(bRank - aRank));
        }
        long aMaxId = BundleDependencyComparator.findHighestServiceId((ServiceReference[])aservices);
        if (aMaxId != (bMaxId = BundleDependencyComparator.findHighestServiceId((ServiceReference[])bservices))) {
            int compare = (int)(bMaxId - aMaxId);
            if (trace) {
                int max = compare > 0 ? (int)bMaxId : (int)aMaxId;
                log.trace((Object)("sorting based on highest-service-id won by bundle " + (compare > 0 ? "1" : "2") + " w/ service id " + max));
            }
            return BundleDependencyComparator.signum(compare);
        }
        return BundleDependencyComparator.signum((int)(a.getBundleId() - b.getBundleId()));
    }

    private static int findHighestServiceRanking(ServiceReference[] refs) {
        int maxRank = Integer.MIN_VALUE;
        for (int i = 0; i < refs.length; ++i) {
            int currentRank = OsgiServiceReferenceUtils.getServiceRanking((ServiceReference)refs[i]);
            if (currentRank <= maxRank) continue;
            maxRank = currentRank;
        }
        return maxRank;
    }

    private static long findHighestServiceId(ServiceReference[] refs) {
        long maxId = Long.MIN_VALUE;
        for (int i = 0; i < refs.length; ++i) {
            long currentId = OsgiServiceReferenceUtils.getServiceId((ServiceReference)refs[i]);
            if (currentId <= maxId) continue;
            maxId = currentId;
        }
        return maxId;
    }

    private static int signum(int a) {
        return a < 0 ? -1 : (a == 0 ? 0 : 1);
    }

    public int compare(Object a, Object b) {
        return BundleDependencyComparator.compareUsingServiceRankingAndId((Bundle)a, (Bundle)b);
    }
}

