/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.blueprint.activator.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.internal.blueprint.activator.support.BlueprintContainerConfig;
import org.springframework.osgi.extender.support.ApplicationContextConfiguration;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ObjectUtils;

public class BlueprintContainerCreator
implements OsgiApplicationContextCreator {
    private static final Log log = LogFactory.getLog(BlueprintContainerCreator.class);

    public DelegatedExecutionOsgiBundleApplicationContext createApplicationContext(BundleContext bundleContext) throws Exception {
        Bundle bundle = bundleContext.getBundle();
        BlueprintContainerConfig config = new BlueprintContainerConfig(bundle);
        String bundleName = OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created configuration " + config + " for bundle " + bundleName));
        }
        if (!config.isSpringPoweredBundle()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No blueprint configuration found in bundle " + bundleName + "; ignoring it..."));
            }
            return null;
        }
        log.info((Object)("Discovered configurations " + ObjectUtils.nullSafeToString((Object[])config.getConfigurationLocations()) + " in bundle [" + bundleName + "]"));
        OsgiBundleXmlApplicationContext sdoac = new OsgiBundleXmlApplicationContext(config.getConfigurationLocations());
        sdoac.setBundleContext(bundleContext);
        sdoac.setPublishContextAsService(((ApplicationContextConfiguration)config).isPublishContextAsService());
        return sdoac;
    }
}

