/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.modulith.test.Scenario;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;

public interface ScenarioCustomizer
extends InvocationInterceptor {
    public Function<ConditionFactory, ConditionFactory> getDefaultCustomizer(Method var1, ApplicationContext var2);

    public static Function<ConditionFactory, ConditionFactory> forwardExecutorService(ApplicationContext context) {
        Supplier<ExecutorService> fallback = () -> {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)context.getBeanProvider(ThreadPoolTaskExecutor.class).getIfUnique();
            return executor == null ? null : executor.getThreadPoolExecutor();
        };
        ExecutorService executorService = (ExecutorService)context.getBeanProvider(ExecutorService.class).getIfUnique(fallback);
        return executorService != null ? it -> it.pollExecutorService(executorService) : Function.identity();
    }

    default public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.prepareScenarioInstance(invocationContext, extensionContext);
        invocation.proceed();
    }

    default public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.prepareScenarioInstance(invocationContext, extensionContext);
        return (T)invocation.proceed();
    }

    default public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.prepareScenarioInstance(invocationContext, extensionContext);
        invocation.proceed();
    }

    private void prepareScenarioInstance(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        invocationContext.getArguments().stream().filter(Scenario.class::isInstance).map(Scenario.class::cast).forEach(it -> {
            ApplicationContext context = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
            Function<ConditionFactory, ConditionFactory> customizer = this.getDefaultCustomizer((Method)invocationContext.getExecutable(), context);
            Assert.state((customizer != null ? 1 : 0) != 0, (String)"Customizer must not be null!");
            it.setDefaultCustomizer(customizer);
        });
    }
}

