/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.docs;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.jmolecules.architecture.cqrs.Command;
import org.jmolecules.architecture.cqrs.CommandDispatcher;
import org.jmolecules.architecture.cqrs.CommandHandler;
import org.jmolecules.architecture.cqrs.QueryModel;
import org.jmolecules.architecture.hexagonal.Adapter;
import org.jmolecules.architecture.hexagonal.Application;
import org.jmolecules.architecture.hexagonal.Port;
import org.jmolecules.architecture.hexagonal.PrimaryAdapter;
import org.jmolecules.architecture.hexagonal.PrimaryPort;
import org.jmolecules.architecture.hexagonal.SecondaryAdapter;
import org.jmolecules.architecture.hexagonal.SecondaryPort;
import org.jmolecules.architecture.layered.ApplicationLayer;
import org.jmolecules.architecture.layered.DomainLayer;
import org.jmolecules.architecture.layered.InfrastructureLayer;
import org.jmolecules.architecture.layered.InterfaceLayer;
import org.jmolecules.architecture.onion.classical.ApplicationServiceRing;
import org.jmolecules.architecture.onion.classical.DomainModelRing;
import org.jmolecules.architecture.onion.classical.DomainServiceRing;
import org.jmolecules.architecture.onion.classical.InfrastructureRing;
import org.jmolecules.architecture.onion.simplified.ApplicationRing;
import org.jmolecules.architecture.onion.simplified.DomainRing;
import org.springframework.modulith.core.SpringBean;
import org.springframework.modulith.docs.Documenter;
import org.springframework.util.ClassUtils;

public class Groupings {
    private static Predicate<SpringBean> packageOrTypeAnnotatedWith(Class<? extends Annotation> annotation) {
        return bean -> {
            JavaClass type = bean.getType();
            JavaPackage pkg = type.getPackage();
            return type.isAnnotatedWith(annotation) || type.isMetaAnnotatedWith(annotation) || pkg.isAnnotatedWith(annotation) || pkg.isMetaAnnotatedWith(annotation);
        };
    }

    public static class JMoleculesGroupings {
        private static final boolean JMOLECULES_CQRS_PRESENT = ClassUtils.isPresent((String)"org.jmolecules.architecture.cqrs.Command", (ClassLoader)JMoleculesGroupings.class.getClassLoader());
        private static final boolean JMOLECULES_HEXAGONAL_PRESENT = ClassUtils.isPresent((String)"org.jmolecules.architecture.hexagonal.Port", (ClassLoader)JMoleculesGroupings.class.getClassLoader());
        private static final boolean JMOLECULES_LAYERS_PRESENT = ClassUtils.isPresent((String)"org.jmolecules.architecture.layered.ApplicationLayer", (ClassLoader)JMoleculesGroupings.class.getClassLoader());
        private static final boolean JMOLECULES_ONION_PRESENT = ClassUtils.isPresent((String)"org.jmolecules.architecture.onion.classical.ApplicationRing", (ClassLoader)JMoleculesGroupings.class.getClassLoader());

        public static Documenter.CanvasOptions.Grouping[] getGroupings() {
            ArrayList<Documenter.CanvasOptions.Grouping> groupings = new ArrayList<Documenter.CanvasOptions.Grouping>();
            if (JMOLECULES_CQRS_PRESENT) {
                groupings.add(Documenter.CanvasOptions.Grouping.of("Commands", Groupings.packageOrTypeAnnotatedWith(Command.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Command dispatchers", Groupings.packageOrTypeAnnotatedWith(CommandDispatcher.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Command handlers", Groupings.packageOrTypeAnnotatedWith(CommandHandler.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Query models", Groupings.packageOrTypeAnnotatedWith(QueryModel.class)));
            }
            if (JMOLECULES_HEXAGONAL_PRESENT) {
                groupings.add(Documenter.CanvasOptions.Grouping.of("Primary ports", Groupings.packageOrTypeAnnotatedWith(PrimaryPort.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Secondary ports", Groupings.packageOrTypeAnnotatedWith(SecondaryPort.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Ports", Groupings.packageOrTypeAnnotatedWith(Port.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Application", Groupings.packageOrTypeAnnotatedWith(Application.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Primary adapters", Groupings.packageOrTypeAnnotatedWith(PrimaryAdapter.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Secondary adapters", Groupings.packageOrTypeAnnotatedWith(SecondaryAdapter.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Adapters", Groupings.packageOrTypeAnnotatedWith(Adapter.class)));
            }
            if (JMOLECULES_LAYERS_PRESENT) {
                groupings.add(Documenter.CanvasOptions.Grouping.of("Application layer", Groupings.packageOrTypeAnnotatedWith(ApplicationLayer.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Domain layer", Groupings.packageOrTypeAnnotatedWith(DomainLayer.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Infrastructure layer", Groupings.packageOrTypeAnnotatedWith(InfrastructureLayer.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Interface layer", Groupings.packageOrTypeAnnotatedWith(InterfaceLayer.class)));
            }
            if (JMOLECULES_ONION_PRESENT) {
                groupings.add(Documenter.CanvasOptions.Grouping.of("Application ring", Groupings.packageOrTypeAnnotatedWith(ApplicationRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Domain ring", Groupings.packageOrTypeAnnotatedWith(DomainRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Infrastructure ring", Groupings.packageOrTypeAnnotatedWith(org.jmolecules.architecture.onion.simplified.InfrastructureRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Application service ring", Groupings.packageOrTypeAnnotatedWith(ApplicationServiceRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Domain service ring", Groupings.packageOrTypeAnnotatedWith(DomainServiceRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Domain model ring", Groupings.packageOrTypeAnnotatedWith(DomainModelRing.class)));
                groupings.add(Documenter.CanvasOptions.Grouping.of("Infrastructure ring", Groupings.packageOrTypeAnnotatedWith(InfrastructureRing.class)));
            }
            return (Documenter.CanvasOptions.Grouping[])groupings.toArray(Documenter.CanvasOptions.Grouping[]::new);
        }
    }

    public static class SpringGroupings {
        public static Documenter.CanvasOptions.Grouping[] getGroupings() {
            return new Documenter.CanvasOptions.Grouping[]{Documenter.CanvasOptions.Grouping.of("Controllers", bean -> bean.toArchitecturallyEvidentType().isController()), Documenter.CanvasOptions.Grouping.of("Services", bean -> bean.toArchitecturallyEvidentType().isService()), Documenter.CanvasOptions.Grouping.of("Repositories", bean -> bean.toArchitecturallyEvidentType().isRepository()), Documenter.CanvasOptions.Grouping.of("Event listeners", bean -> bean.toArchitecturallyEvidentType().isEventListener()), Documenter.CanvasOptions.Grouping.of("Configuration properties", bean -> bean.toArchitecturallyEvidentType().isConfigurationProperties())};
        }
    }
}

