/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools;

import java.util.Collection;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.springframework.modulith.aptk.tools.ProcessingEnvironmentUtils;
import org.springframework.modulith.aptk.tools.corematcher.PlainValidationMessage;
import org.springframework.modulith.aptk.tools.corematcher.ValidationMessage;

public final class MessagerUtils {
    private static boolean printMessageCodes = false;

    private MessagerUtils() {
    }

    public static void setPrintMessageCodes(boolean printMessageCodes) {
        MessagerUtils.printMessageCodes = printMessageCodes;
    }

    public static void error(Element e, String message, Object ... args) {
        MessagerUtils.error(e, PlainValidationMessage.create(message), args);
    }

    public static void warning(Element e, String message, Object ... args) {
        MessagerUtils.warning(e, PlainValidationMessage.create(message), args);
    }

    public static void mandatoryWarning(Element e, String message, Object ... args) {
        MessagerUtils.mandatoryWarning(e, PlainValidationMessage.create(message), args);
    }

    public static void info(Element e, String message, Object ... args) {
        MessagerUtils.info(e, PlainValidationMessage.create(message), args);
    }

    public static void other(Element e, String message, Object ... args) {
        MessagerUtils.other(e, PlainValidationMessage.create(message), args);
    }

    public static void error(Element e, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, Diagnostic.Kind.ERROR, message, args);
    }

    public static void warning(Element e, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, Diagnostic.Kind.WARNING, message, args);
    }

    public static void mandatoryWarning(Element e, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, Diagnostic.Kind.MANDATORY_WARNING, message, args);
    }

    public static void info(Element e, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, Diagnostic.Kind.NOTE, message, args);
    }

    public static void other(Element e, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, Diagnostic.Kind.OTHER, message, args);
    }

    public static void error(Element e, AnnotationMirror a, String message, Object ... args) {
        MessagerUtils.error(e, a, PlainValidationMessage.create(message), args);
    }

    public static void warning(Element e, AnnotationMirror a, String message, Object ... args) {
        MessagerUtils.warning(e, a, PlainValidationMessage.create(message), args);
    }

    public static void mandatoryWarning(Element e, AnnotationMirror a, String message, Object ... args) {
        MessagerUtils.mandatoryWarning(e, a, PlainValidationMessage.create(message), args);
    }

    public static void info(Element e, AnnotationMirror a, String message, Object ... args) {
        MessagerUtils.info(e, a, PlainValidationMessage.create(message), args);
    }

    public static void other(Element e, AnnotationMirror a, String message, Object ... args) {
        MessagerUtils.other(e, a, PlainValidationMessage.create(message), args);
    }

    public static void error(Element e, AnnotationMirror a, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, Diagnostic.Kind.ERROR, message, args);
    }

    public static void warning(Element e, AnnotationMirror a, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, Diagnostic.Kind.WARNING, message, args);
    }

    public static void mandatoryWarning(Element e, AnnotationMirror a, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, Diagnostic.Kind.MANDATORY_WARNING, message, args);
    }

    public static void info(Element e, AnnotationMirror a, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, Diagnostic.Kind.NOTE, message, args);
    }

    public static void other(Element e, AnnotationMirror a, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, Diagnostic.Kind.OTHER, message, args);
    }

    public static void error(Element e, AnnotationMirror a, AnnotationValue v, String message, Object ... args) {
        MessagerUtils.error(e, a, v, PlainValidationMessage.create(message), args);
    }

    public static void warning(Element e, AnnotationMirror a, AnnotationValue v, String message, Object ... args) {
        MessagerUtils.warning(e, a, v, PlainValidationMessage.create(message), args);
    }

    public static void mandatoryWarning(Element e, AnnotationMirror a, AnnotationValue v, String message, Object ... args) {
        MessagerUtils.mandatoryWarning(e, a, v, PlainValidationMessage.create(message), args);
    }

    public static void info(Element e, AnnotationMirror a, AnnotationValue v, String message, Object ... args) {
        MessagerUtils.info(e, a, v, PlainValidationMessage.create(message), args);
    }

    public static void other(Element e, AnnotationMirror a, AnnotationValue v, String message, Object ... args) {
        MessagerUtils.other(e, a, v, PlainValidationMessage.create(message), args);
    }

    public static void error(Element e, AnnotationMirror a, AnnotationValue v, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, Diagnostic.Kind.ERROR, message, args);
    }

    public static void warning(Element e, AnnotationMirror a, AnnotationValue v, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, Diagnostic.Kind.WARNING, message, args);
    }

    public static void mandatoryWarning(Element e, AnnotationMirror a, AnnotationValue v, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, Diagnostic.Kind.MANDATORY_WARNING, message, args);
    }

    public static void info(Element e, AnnotationMirror a, AnnotationValue v, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, Diagnostic.Kind.NOTE, message, args);
    }

    public static void other(Element e, AnnotationMirror a, AnnotationValue v, ValidationMessage message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, Diagnostic.Kind.OTHER, message, args);
    }

    public static void printMessage(Element e, Diagnostic.Kind kind, String message, Object ... args) {
        MessagerUtils.printMessage(e, kind, PlainValidationMessage.create(message), args);
    }

    public static void printMessage(Element e, AnnotationMirror a, Diagnostic.Kind kind, String message, Object ... args) {
        MessagerUtils.printMessage(e, a, kind, PlainValidationMessage.create(message), args);
    }

    public static void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Diagnostic.Kind kind, String message, Object ... args) {
        MessagerUtils.printMessage(e, a, v, kind, PlainValidationMessage.create(message), args);
    }

    public static void printMessage(Element e, Diagnostic.Kind kind, ValidationMessage message, Object ... args) {
        ProcessingEnvironmentUtils.getMessager().printMessage(kind, MessagerUtils.createMessage(message, args), e);
    }

    public static void printMessage(Element e, AnnotationMirror a, Diagnostic.Kind kind, ValidationMessage message, Object ... args) {
        ProcessingEnvironmentUtils.getMessager().printMessage(kind, MessagerUtils.createMessage(message, args), e, a);
    }

    public static void printMessage(Element e, AnnotationMirror a, AnnotationValue v, Diagnostic.Kind kind, ValidationMessage message, Object ... args) {
        ProcessingEnvironmentUtils.getMessager().printMessage(kind, MessagerUtils.createMessage(message, args), e, a, v);
    }

    public static Messager getMessager() {
        return ProcessingEnvironmentUtils.getMessager();
    }

    public static String createMessage(String message, Object ... messageParameters) {
        String result = message;
        if (messageParameters != null) {
            for (int i = 0; i < messageParameters.length; ++i) {
                result = result.replaceAll("\\$\\{" + i + "\\}", messageParameters[i] != null ? messageParameters[i].toString() : "null");
            }
        }
        return result;
    }

    public static String createMessage(ValidationMessage message, Object ... messageParameters) {
        String result = (printMessageCodes && message.getCode() != null && !message.getCode().isEmpty() ? "[" + message.getCode() + "] : " : "") + message.getMessage();
        if (messageParameters != null) {
            for (int i = 0; i < messageParameters.length; ++i) {
                result = result.replaceAll("\\$\\{" + i + "\\}", messageParameters[i] != null ? MessagerUtils.argToString(messageParameters[i]) : "null");
            }
        }
        return result;
    }

    static String argToString(Object arg) {
        if (arg == null) {
            return "<NULL>";
        }
        if (arg.getClass().isArray()) {
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean first = true;
            for (Object argument : (Object[])arg) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(MessagerUtils.argToString(argument));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (Collection.class.isAssignableFrom(arg.getClass())) {
            StringBuilder stringBuilder = new StringBuilder("[");
            boolean first = true;
            for (Object argument : (Collection)arg) {
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(MessagerUtils.argToString(argument));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        return arg.toString();
    }
}

