/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.core.impl;

import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.odm.core.OdmManager;
import org.springframework.ldap.odm.core.impl.DefaultObjectDirectoryMapper;
import org.springframework.ldap.odm.typeconversion.ConverterManager;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.util.StringUtils;

public final class OdmManagerImpl
implements OdmManager {
    private final LdapTemplate ldapTemplate;
    private DefaultObjectDirectoryMapper objectDirectoryMapper;

    public OdmManagerImpl(ConverterManager converterManager, LdapOperations ldapOperations, Set<Class<?>> managedClasses) {
        this.ldapTemplate = (LdapTemplate)ldapOperations;
        this.objectDirectoryMapper = new DefaultObjectDirectoryMapper();
        if (converterManager != null) {
            this.objectDirectoryMapper.setConverterManager(converterManager);
        }
        if (managedClasses != null) {
            for (Class<?> managedClass : managedClasses) {
                this.addManagedClass(managedClass);
            }
        }
        this.ldapTemplate.setObjectDirectoryMapper((ObjectDirectoryMapper)this.objectDirectoryMapper);
    }

    public OdmManagerImpl(ConverterManager converterManager, ContextSource contextSource, Set<Class<?>> managedClasses) {
        this(converterManager, (LdapOperations)new LdapTemplate(contextSource), managedClasses);
    }

    public OdmManagerImpl(ConverterManager converterManager, ContextSource contextSource) {
        this(converterManager, contextSource, null);
    }

    public void addManagedClass(Class<?> managedClass) {
        this.objectDirectoryMapper.manageClass(managedClass);
    }

    @Override
    public <T> T read(Class<T> clazz, Name dn) {
        return (T)this.ldapTemplate.findByDn(dn, clazz);
    }

    @Override
    public void create(Object entry) {
        this.ldapTemplate.create(entry);
    }

    @Override
    public void update(Object entry) {
        this.ldapTemplate.update(entry);
    }

    @Override
    public void delete(Object entry) {
        this.ldapTemplate.delete(entry);
    }

    @Override
    public <T> List<T> search(Class<T> managedClass, Name base, String filter, SearchControls scope) {
        HardcodedFilter searchFilter = null;
        if (StringUtils.hasText((String)filter)) {
            searchFilter = new HardcodedFilter(filter);
        }
        return this.ldapTemplate.find(base, (Filter)searchFilter, scope, managedClass);
    }

    @Override
    public <T> List<T> search(Class<T> clazz, LdapQuery query) {
        return this.ldapTemplate.find(query, clazz);
    }

    @Override
    public <T> List<T> findAll(Class<T> managedClass, Name base, SearchControls scope) {
        return this.ldapTemplate.findAll(base, scope, managedClass);
    }
}

