/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.zip.transformer.AbstractZipTransformer;
import org.springframework.integration.zip.transformer.SpringZipUtils;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipEntrySource;

public class ZipTransformer
extends AbstractZipTransformer {
    private static final Log logger = LogFactory.getLog(ZipTransformer.class);
    private static final String ZIP_EXTENSION = ".zip";
    private volatile int compressionLevel = -1;
    private volatile boolean useFileAttributes = true;

    public void setCompressionLevel(int compressionLevel) {
        Assert.isTrue((compressionLevel >= 0 && compressionLevel <= 9 ? 1 : 0) != 0, (String)"Acceptable levels are 0-9");
        this.compressionLevel = compressionLevel;
    }

    public void setUseFileAttributes(boolean useFileAttributes) {
        this.useFileAttributes = useFileAttributes;
    }

    @Override
    protected Object doZipTransform(Message<?> message) throws Exception {
        Object zippedData;
        Object payload = message.getPayload();
        String baseFileName = this.fileNameGenerator.generateFileName(message);
        String zipEntryName = message.getHeaders().containsKey((Object)"zip_entryFilename") ? (String)message.getHeaders().get((Object)"zip_entryFilename") : baseFileName;
        String zipFileName = message.getHeaders().containsKey((Object)"file_name") ? (String)message.getHeaders().get((Object)"file_name") : baseFileName + ZIP_EXTENSION;
        Date lastModifiedDate = message.getHeaders().containsKey((Object)"zip_entryLastModifiedDate") ? (Date)message.getHeaders().get((Object)"zip_entryLastModifiedDate") : new Date();
        ArrayList<ZipEntrySource> entries = new ArrayList<ZipEntrySource>();
        if (payload instanceof Iterable) {
            int counter = 1;
            String baseName = FilenameUtils.getBaseName((String)zipEntryName);
            String fileExtension = FilenameUtils.getExtension((String)zipEntryName);
            if (StringUtils.hasText((String)fileExtension)) {
                fileExtension = FilenameUtils.EXTENSION_SEPARATOR_STR + fileExtension;
            }
            for (Object item : (Iterable)payload) {
                ZipEntrySource zipEntrySource = this.createZipEntrySource(item, lastModifiedDate, baseName + "_" + counter + fileExtension, this.useFileAttributes);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ZipEntrySource path: '" + zipEntrySource.getPath() + "'"));
                }
                entries.add(zipEntrySource);
                ++counter;
            }
        } else {
            ZipEntrySource zipEntrySource = this.createZipEntrySource(payload, lastModifiedDate, zipEntryName, this.useFileAttributes);
            entries.add(zipEntrySource);
        }
        byte[] zippedBytes = SpringZipUtils.pack(entries, this.compressionLevel);
        if (ZipResultType.FILE.equals((Object)this.zipResultType)) {
            File zippedFile = new File(this.workDirectory, zipFileName);
            FileCopyUtils.copy((byte[])zippedBytes, (File)zippedFile);
            zippedData = zippedFile;
        } else if (ZipResultType.BYTE_ARRAY.equals((Object)this.zipResultType)) {
            zippedData = zippedBytes;
        } else {
            throw new IllegalStateException("Unsupported zipResultType " + (Object)((Object)this.zipResultType));
        }
        if (this.deleteFiles) {
            if (payload instanceof Iterable) {
                for (Object item : (Iterable)payload) {
                    this.deleteFile(item);
                }
            } else {
                this.deleteFile(payload);
            }
        }
        return this.getMessageBuilderFactory().withPayload(zippedData).copyHeaders((Map)message.getHeaders()).setHeader("file_name", (Object)zipFileName).build();
    }

    private void deleteFile(Object fileToDelete) {
        if (fileToDelete instanceof File && !((File)fileToDelete).delete() && logger.isWarnEnabled()) {
            logger.warn((Object)("Failed to delete File '" + fileToDelete + "'"));
        }
    }

    private ZipEntrySource createZipEntrySource(Object item, Date lastModifiedDate, String zipEntryName, boolean useFileAttributes) {
        if (item instanceof File) {
            String fileName;
            File filePayload = (File)item;
            String string = fileName = useFileAttributes ? filePayload.getName() : zipEntryName;
            if (((File)item).isDirectory()) {
                throw new UnsupportedOperationException("Zipping of directories is not supported.");
            }
            return new FileSource(fileName, filePayload);
        }
        if (item instanceof byte[] || item instanceof String) {
            byte[] bytesToCompress = null;
            bytesToCompress = item instanceof String ? ((String)item).getBytes(this.charset) : (byte[])item;
            return new ByteSource(zipEntryName, bytesToCompress, lastModifiedDate.getTime());
        }
        throw new IllegalArgumentException("Unsupported payload type. The only supported payloads are java.io.File, java.lang.String, and byte[]");
    }
}

