/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.inbound;

import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareEndpoint;
import org.springframework.integration.xmpp.support.DefaultXmppHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.util.Assert;

public class ChatMessageListeningEndpoint
extends AbstractXmppConnectionAwareEndpoint {
    private final StanzaListener stanzaListener = new ChatMessagePublishingStanzaListener();
    private XmppHeaderMapper headerMapper = new DefaultXmppHeaderMapper();
    private Expression payloadExpression;
    private StanzaFilter stanzaFilter;
    private EvaluationContext evaluationContext;

    public ChatMessageListeningEndpoint() {
    }

    public ChatMessageListeningEndpoint(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setHeaderMapper(XmppHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setStanzaFilter(StanzaFilter stanzaFilter) {
        this.stanzaFilter = stanzaFilter;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public String getComponentType() {
        return "xmpp:inbound-channel-adapter";
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void doStart() {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + " [" + this.getComponentType() + "] must be initialized"));
        this.xmppConnection.addAsyncStanzaListener(this.stanzaListener, this.stanzaFilter);
    }

    protected void doStop() {
        if (this.xmppConnection != null) {
            this.xmppConnection.removeAsyncStanzaListener(this.stanzaListener);
        }
    }

    private class ChatMessagePublishingStanzaListener
    implements StanzaListener {
        ChatMessagePublishingStanzaListener() {
        }

        public void processStanza(Stanza packet) {
            if (packet instanceof Message) {
                Message xmppMessage = (Message)packet;
                Map mappedHeaders = ChatMessageListeningEndpoint.this.headerMapper.toHeadersFromRequest(xmppMessage);
                Object messageBody = xmppMessage.getBody();
                if (ChatMessageListeningEndpoint.this.payloadExpression != null) {
                    EvaluationContext evaluationContextToUse = ChatMessageListeningEndpoint.this.evaluationContext;
                    List extensions = xmppMessage.getExtensions();
                    if (extensions.size() == 1) {
                        ExtensionElement extension = (ExtensionElement)extensions.get(0);
                        evaluationContextToUse = ExpressionUtils.createStandardEvaluationContext((BeanFactory)ChatMessageListeningEndpoint.this.getBeanFactory());
                        evaluationContextToUse.setVariable("extension", (Object)extension);
                    }
                    messageBody = ChatMessageListeningEndpoint.this.payloadExpression.getValue(evaluationContextToUse, (Object)xmppMessage);
                }
                if (messageBody != null) {
                    ChatMessageListeningEndpoint.this.sendMessage(ChatMessageListeningEndpoint.this.getMessageBuilderFactory().withPayload(messageBody).copyHeaders(mappedHeaders).build());
                } else if (ChatMessageListeningEndpoint.this.logger.isInfoEnabled()) {
                    if (ChatMessageListeningEndpoint.this.payloadExpression != null) {
                        ChatMessageListeningEndpoint.this.logger.info((Object)("The 'payloadExpression' [" + ChatMessageListeningEndpoint.this.payloadExpression.getExpressionString() + "] has been evaluated to 'null'. The XMPP Message [" + xmppMessage + "] is ignored."));
                    } else {
                        ChatMessageListeningEndpoint.this.logger.info((Object)("The XMPP Message [" + xmppMessage + "] with empty body is ignored."));
                    }
                }
            }
        }
    }
}

