/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class XmppConnectionFactoryBean
extends AbstractFactoryBean<XMPPConnection>
implements SmartLifecycle {
    private final ConnectionConfiguration connectionConfiguration;
    private volatile String resource = null;
    private volatile String user;
    private volatile String password;
    private volatile String subscriptionMode = "accept_all";
    private volatile XMPPConnection connection;
    private volatile boolean autoStartup = true;
    private volatile int phase = Integer.MIN_VALUE;
    private final Object lifecycleMonitor = new Object();
    private volatile boolean running;

    public XmppConnectionFactoryBean(ConnectionConfiguration connectionConfiguration) {
        Assert.notNull((Object)connectionConfiguration, (String)"'connectionConfiguration' must not be null");
        this.connectionConfiguration = connectionConfiguration;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setSubscriptionMode(String subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Class<? extends XMPPConnection> getObjectType() {
        return XMPPConnection.class;
    }

    protected XMPPConnection createInstance() throws Exception {
        this.connection = new XMPPTCPConnection(this.connectionConfiguration);
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            try {
                this.connection.connect();
                this.connection.addConnectionListener((ConnectionListener)new LoggingConnectionListener());
                if (StringUtils.hasText((String)this.user)) {
                    this.connection.login(this.user, this.password, this.resource);
                    Assert.isTrue((boolean)this.connection.isAuthenticated(), (String)("Failed to authenticate user: " + this.user));
                    if (StringUtils.hasText((String)this.subscriptionMode)) {
                        Roster.SubscriptionMode subscriptionMode = Roster.SubscriptionMode.valueOf((String)this.subscriptionMode);
                        this.connection.getRoster().setSubscriptionMode(subscriptionMode);
                    }
                } else {
                    this.connection.loginAnonymously();
                }
                this.running = true;
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to connect to XMPP service for " + this.connectionConfiguration.getServiceName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                try {
                    this.connection.disconnect();
                }
                catch (SmackException.NotConnectedException notConnectedException) {
                    // empty catch block
                }
                this.running = false;
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    private class LoggingConnectionListener
    implements ConnectionListener {
        private LoggingConnectionListener() {
        }

        public void reconnectionSuccessful() {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Reconnection successful");
        }

        public void reconnectionFailed(Exception e) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Reconnection failed", (Throwable)e);
        }

        public void reconnectingIn(int seconds) {
            XmppConnectionFactoryBean.this.logger.debug((Object)("Reconnecting in " + seconds + " seconds"));
        }

        public void connectionClosedOnError(Exception e) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed on error", (Throwable)e);
        }

        public void connectionClosed() {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed");
        }

        public void connected(XMPPConnection connection) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection connected");
        }

        public void authenticated(XMPPConnection connection) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection authenticated");
        }
    }
}

