/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.integration.xml.result.DomResultFactory;
import org.springframework.integration.xml.result.StringResultFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class XmlNamespaceUtils {
    private static final String DOM_RESULT = "DOMResult";
    private static final String STRING_RESULT = "StringResult";

    XmlNamespaceUtils() {
    }

    static void configureResultFactory(BeanDefinitionBuilder builder, String resultType, String resultFactory) {
        boolean bothHaveText = StringUtils.hasText((String)resultFactory) && StringUtils.hasText((String)resultType);
        Assert.state((!bothHaveText ? 1 : 0) != 0, (String)"Only one of 'result-factory' or 'result-type' should be specified.");
        if (StringUtils.hasText((String)resultType)) {
            Assert.state((resultType.equals(DOM_RESULT) || resultType.equals(STRING_RESULT) ? 1 : 0) != 0, (String)"Result type must be either 'DOMResult' or 'StringResult'");
        }
        if (StringUtils.hasText((String)resultFactory)) {
            builder.addPropertyReference("resultFactory", resultFactory);
        } else if (resultType.equals(STRING_RESULT)) {
            builder.addPropertyValue("resultFactory", (Object)new StringResultFactory());
        } else {
            builder.addPropertyValue("resultFactory", (Object)new DomResultFactory());
        }
    }
}

