/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.io.IOException;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.ws.AbstractWebServiceInboundGateway;
import org.springframework.messaging.Message;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.support.MarshallingUtils;

public class MarshallingWebServiceInboundGateway
extends AbstractWebServiceInboundGateway {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public MarshallingWebServiceInboundGateway() {
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must not be null");
        Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller, (String)"When using this constructor the provided Marshaller must also implement Unmarshaller");
        this.marshaller = marshaller;
        this.unmarshaller = (Unmarshaller)marshaller;
    }

    public MarshallingWebServiceInboundGateway(Marshaller marshaller, Unmarshaller unmarshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must not be null");
        Assert.notNull((Object)unmarshaller, (String)"'unmarshaller' must not be null");
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"'marshaller' must not be null");
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"'unmarshaller' must not be null");
        this.unmarshaller = unmarshaller;
    }

    protected void onInit() {
        super.onInit();
        Assert.notNull((Object)this.marshaller, (String)"This implementation requires Marshaller");
        Assert.notNull((Object)this.unmarshaller, (String)"This implementation requires Unmarshaller");
    }

    @Override
    protected void doInvoke(MessageContext messageContext) throws IOException {
        WebServiceMessage request = messageContext.getRequest();
        Assert.notNull((Object)request, (String)"Invalid message context: request was null.");
        Object requestObject = MarshallingUtils.unmarshal((Unmarshaller)this.unmarshaller, (WebServiceMessage)request);
        Assert.state((requestObject != null ? 1 : 0) != 0, (String)"Invalid message context: Request object was null");
        AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload(requestObject);
        this.fromSoapHeaders(messageContext, builder);
        Message replyMessage = this.sendAndReceiveMessage(builder.build());
        if (replyMessage != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.toSoapHeaders(response, replyMessage);
            MarshallingUtils.marshal((Marshaller)this.marshaller, (Object)replyMessage.getPayload(), (WebServiceMessage)response);
        }
    }
}

