/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.config;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class IntegrationDynamicWebSocketHandlerMapping
extends AbstractUrlHandlerMapping {
    private final Map<String, HttpRequestHandler> handlerMap = new HashMap<String, HttpRequestHandler>();
    private final Map<PathPattern, HttpRequestHandler> pathPatternHandlerMap = new LinkedHashMap<PathPattern, HttpRequestHandler>();

    IntegrationDynamicWebSocketHandlerMapping() {
    }

    protected Object getHandlerInternal(HttpServletRequest request) {
        String lookupPath = this.initLookupPath(request);
        HttpRequestHandler httpRequestHandler = this.handlerMap.get(lookupPath);
        if (httpRequestHandler == null && this.usesPathPatterns()) {
            RequestPath path = ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request);
            return this.lookupByPattern(path);
        }
        return httpRequestHandler != null ? new HandlerExecutionChain((Object)httpRequestHandler) : null;
    }

    private Object lookupByPattern(RequestPath path) {
        List matches = null;
        for (PathPattern pattern : this.pathPatternHandlerMap.keySet()) {
            if (!pattern.matches(path.pathWithinApplication())) continue;
            matches = matches != null ? matches : new ArrayList();
            matches.add(pattern);
        }
        if (matches == null) {
            return null;
        }
        if (matches.size() > 1) {
            matches.sort(PathPattern.SPECIFICITY_COMPARATOR);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Matching patterns " + String.valueOf(matches)));
            }
        }
        PathPattern pattern = (PathPattern)matches.get(0);
        HttpRequestHandler handler = this.pathPatternHandlerMap.get(pattern);
        PathContainer pathWithinMapping = pattern.extractPathWithinPattern(path.pathWithinApplication());
        return this.buildPathExposingHandler(handler, pattern.getPatternString(), pathWithinMapping.value(), null);
    }

    void registerHandler(String path, HttpRequestHandler httpHandler) {
        this.handlerMap.put(path, httpHandler);
        PathPatternParser patternParser = this.getPatternParser();
        if (patternParser != null) {
            this.pathPatternHandlerMap.put(patternParser.parse(path), httpHandler);
        }
    }

    void unregisterHandler(String path) {
        this.handlerMap.remove(path);
        PathPatternParser patternParser = this.getPatternParser();
        if (patternParser != null) {
            this.pathPatternHandlerMap.remove(patternParser.parse(path));
        }
    }
}

