/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.inbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.Lifecycle;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.websocket.IntegrationWebSocketContainer;
import org.springframework.integration.websocket.ServerWebSocketContainer;
import org.springframework.integration.websocket.WebSocketListener;
import org.springframework.integration.websocket.event.ReceiptEvent;
import org.springframework.integration.websocket.support.PassThruSubProtocolHandler;
import org.springframework.integration.websocket.support.SubProtocolHandlerRegistry;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.broker.AbstractBrokerMessageHandler;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.SessionConnectedEvent;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public class WebSocketInboundChannelAdapter
extends MessageProducerSupport
implements WebSocketListener,
ApplicationEventPublisherAware {
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private final List<MessageConverter> defaultConverters = new ArrayList<MessageConverter>(3);
    private final CompositeMessageConverter messageConverter;
    private final IntegrationWebSocketContainer webSocketContainer;
    private final boolean server;
    private final SubProtocolHandlerRegistry subProtocolHandlerRegistry;
    private final MessageChannel subProtocolHandlerChannel;
    private final AtomicReference<Class<?>> payloadType;
    private ApplicationEventPublisher eventPublisher;
    private List<MessageConverter> messageConverters;
    private boolean mergeWithDefaultConverters;
    private boolean useBroker;
    private AbstractBrokerMessageHandler brokerHandler;

    public WebSocketInboundChannelAdapter(IntegrationWebSocketContainer webSocketContainer) {
        this(webSocketContainer, new SubProtocolHandlerRegistry(new PassThruSubProtocolHandler()));
    }

    public WebSocketInboundChannelAdapter(IntegrationWebSocketContainer webSocketContainer, SubProtocolHandlerRegistry protocolHandlerRegistry) {
        this.defaultConverters.add((MessageConverter)new StringMessageConverter());
        this.defaultConverters.add((MessageConverter)new ByteArrayMessageConverter());
        if (JacksonPresent.isJackson2Present()) {
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            this.defaultConverters.add((MessageConverter)converter);
        }
        this.messageConverter = new CompositeMessageConverter(this.defaultConverters);
        this.payloadType = new AtomicReference<Class<String>>(String.class);
        this.mergeWithDefaultConverters = false;
        Assert.notNull((Object)webSocketContainer, (String)"'webSocketContainer' must not be null");
        Assert.notNull((Object)protocolHandlerRegistry, (String)"'protocolHandlerRegistry' must not be null");
        this.webSocketContainer = webSocketContainer;
        this.server = this.webSocketContainer instanceof ServerWebSocketContainer;
        this.subProtocolHandlerRegistry = protocolHandlerRegistry;
        this.subProtocolHandlerChannel = new FixedSubscriberChannel(message -> {
            try {
                this.handleMessageAndSend(message);
            }
            catch (Exception ex) {
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary((Message)message, () -> "Failed to handle and process message in the [" + this + ']', (Throwable)ex);
            }
        });
    }

    public void setMessageConverters(List<MessageConverter> messageConverters) {
        Assert.noNullElements((Object[])messageConverters.toArray(), (String)"'messageConverters' must not contain null entries");
        this.messageConverters = new ArrayList<MessageConverter>(messageConverters);
    }

    public void setMergeWithDefaultConverters(boolean mergeWithDefaultConverters) {
        this.mergeWithDefaultConverters = mergeWithDefaultConverters;
    }

    public void setPayloadType(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"'payloadType' must not be null");
        this.payloadType.set(payloadType);
    }

    public void setUseBroker(boolean useBroker) {
        this.useBroker = useBroker;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    protected void onInit() {
        super.onInit();
        this.webSocketContainer.setMessageListener(this);
        if (!CollectionUtils.isEmpty(this.messageConverters)) {
            List converters = this.messageConverter.getConverters();
            if (this.mergeWithDefaultConverters) {
                ListIterator<MessageConverter> iterator = this.messageConverters.listIterator(this.messageConverters.size());
                while (iterator.hasPrevious()) {
                    MessageConverter converter = iterator.previous();
                    converters.add(0, converter);
                }
            } else {
                converters.clear();
                converters.addAll(this.messageConverters);
            }
        }
        if (this.server && this.useBroker) {
            Map brokers = this.getApplicationContext().getBeansOfType(AbstractBrokerMessageHandler.class);
            for (AbstractBrokerMessageHandler broker : brokers.values()) {
                if (!(broker instanceof SimpleBrokerMessageHandler) && !(broker instanceof StompBrokerRelayMessageHandler)) continue;
                this.brokerHandler = broker;
                break;
            }
            Assert.state((this.brokerHandler != null ? 1 : 0) != 0, (String)"WebSocket Broker Relay isn't present in the application context; it is required when 'useBroker = true'.");
        }
    }

    public List<String> getSubProtocols() {
        return this.subProtocolHandlerRegistry.getSubProtocols();
    }

    @Override
    public void afterSessionStarted(WebSocketSession session) throws Exception {
        if (this.isActive()) {
            SubProtocolHandler protocolHandler = this.subProtocolHandlerRegistry.findProtocolHandler(session);
            protocolHandler.afterSessionStarted(session, this.subProtocolHandlerChannel);
            if (!this.server && protocolHandler instanceof StompSubProtocolHandler) {
                StompHeaderAccessor accessor = StompHeaderAccessor.create((StompCommand)StompCommand.CONNECT);
                accessor.setSessionId(session.getId());
                accessor.setLeaveMutable(true);
                accessor.setAcceptVersion("1.1,1.2");
                Message connectMessage = MessageBuilder.createMessage((Object)EMPTY_PAYLOAD, (MessageHeaders)accessor.getMessageHeaders());
                protocolHandler.handleMessageToClient(session, connectMessage);
            }
        }
    }

    @Override
    public void afterSessionEnded(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        if (this.isActive()) {
            this.subProtocolHandlerRegistry.findProtocolHandler(session).afterSessionEnded(session, closeStatus, this.subProtocolHandlerChannel);
        }
    }

    @Override
    public void onMessage(WebSocketSession session, WebSocketMessage<?> webSocketMessage) throws Exception {
        if (this.isActive()) {
            this.subProtocolHandlerRegistry.findProtocolHandler(session).handleMessageFromClient(session, webSocketMessage, this.subProtocolHandlerChannel);
        }
    }

    public String getComponentType() {
        return "websocket:inbound-channel-adapter";
    }

    protected void doStart() {
        if (this.webSocketContainer instanceof Lifecycle) {
            ((Lifecycle)this.webSocketContainer).start();
        }
    }

    protected void doStop() {
        if (this.webSocketContainer instanceof Lifecycle) {
            ((Lifecycle)this.webSocketContainer).stop();
        }
    }

    public boolean isActive() {
        boolean active = super.isActive();
        if (!active) {
            this.logger.warn((CharSequence)("MessageProducer '" + this + "' isn't started to accept WebSocket events."));
        }
        return active;
    }

    private void handleMessageAndSend(Message<?> message) {
        SimpMessageType messageType;
        StompCommand stompCommand;
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.wrap(message);
        if (this.isProcessingTypeOrCommand(headerAccessor, stompCommand = (StompCommand)headerAccessor.getHeader("stompCommand"), messageType = headerAccessor.getMessageType())) {
            if (SimpMessageType.CONNECT.equals((Object)messageType)) {
                this.produceConnectAckMessage(message, headerAccessor);
            } else if (StompCommand.CONNECTED.equals((Object)stompCommand)) {
                this.eventPublisher.publishEvent((ApplicationEvent)new SessionConnectedEvent((Object)this, message));
            } else if (StompCommand.RECEIPT.equals((Object)stompCommand)) {
                this.eventPublisher.publishEvent((ApplicationEvent)new ReceiptEvent(this, message));
            } else {
                this.produceMessage(message, headerAccessor);
            }
        } else if (this.useBroker) {
            this.brokerHandler.handleMessage(message);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Messages with non 'SimpMessageType.MESSAGE' type are ignored for sending to the 'outputChannel'. They have to be emitted as 'ApplicationEvent's from the 'SubProtocolHandler'. Or using 'AbstractBrokerMessageHandler'(useBroker = true) from server side. Received message: " + message));
        }
    }

    private boolean isProcessingTypeOrCommand(SimpMessageHeaderAccessor headerAccessor, StompCommand stompCommand, SimpMessageType messageType) {
        return (messageType == null || SimpMessageType.MESSAGE.equals((Object)messageType) || SimpMessageType.CONNECT.equals((Object)messageType) && !this.useBroker || StompCommand.CONNECTED.equals((Object)stompCommand) || StompCommand.RECEIPT.equals((Object)stompCommand)) && !this.checkDestinationPrefix(headerAccessor.getDestination());
    }

    private boolean checkDestinationPrefix(String destination) {
        if (this.useBroker) {
            Collection destinationPrefixes = this.brokerHandler.getDestinationPrefixes();
            if (destination == null || CollectionUtils.isEmpty((Collection)destinationPrefixes)) {
                return false;
            }
            return destinationPrefixes.stream().anyMatch(destination::startsWith);
        }
        return false;
    }

    private void produceConnectAckMessage(Message<?> message, SimpMessageHeaderAccessor headerAccessor) {
        String sessionId = headerAccessor.getSessionId();
        SimpMessageHeaderAccessor connectAck = SimpMessageHeaderAccessor.create((SimpMessageType)SimpMessageType.CONNECT_ACK);
        connectAck.setSessionId(sessionId);
        connectAck.setHeader("simpConnectMessage", message);
        Message ackMessage = MessageBuilder.createMessage((Object)EMPTY_PAYLOAD, (MessageHeaders)connectAck.getMessageHeaders());
        WebSocketSession session = this.webSocketContainer.getSession(sessionId);
        try {
            this.subProtocolHandlerRegistry.findProtocolHandler(session).handleMessageToClient(session, ackMessage);
        }
        catch (Exception e) {
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Error sending connect ack message in the [" + this + ']', (Throwable)e);
        }
    }

    private void produceMessage(Message<?> message, SimpMessageHeaderAccessor headerAccessor) {
        headerAccessor.removeHeader("nativeHeaders");
        Object payload = this.messageConverter.fromMessage(message, this.payloadType.get());
        Assert.state((payload != null ? 1 : 0) != 0, () -> "The message converter '" + this.messageConverter + "' produced no payload for message '" + message + "' and expected payload type: " + this.payloadType.get());
        Message messageToSend = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headerAccessor.toMap()).build();
        this.sendMessage(messageToSend);
    }
}

