/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.websocket.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.messaging.SubProtocolHandler;

public final class SubProtocolHandlerRegistry {
    private static final Log LOGGER = LogFactory.getLog(SubProtocolHandlerRegistry.class);
    private final Map<String, SubProtocolHandler> protocolHandlers = new TreeMap<String, SubProtocolHandler>(String.CASE_INSENSITIVE_ORDER);
    private final SubProtocolHandler defaultProtocolHandler;

    public SubProtocolHandlerRegistry(List<SubProtocolHandler> protocolHandlers) {
        this(protocolHandlers, null);
    }

    public SubProtocolHandlerRegistry(SubProtocolHandler defaultProtocolHandler) {
        this(null, defaultProtocolHandler);
    }

    public SubProtocolHandlerRegistry(List<SubProtocolHandler> protocolHandlers, SubProtocolHandler defaultProtocolHandler) {
        Assert.state((!CollectionUtils.isEmpty(protocolHandlers) || defaultProtocolHandler != null ? 1 : 0) != 0, (String)"One of 'protocolHandlers' or 'defaultProtocolHandler' must be provided");
        this.configureProtocolHandlers(protocolHandlers);
        if (this.protocolHandlers.size() == 1 && defaultProtocolHandler == null) {
            this.defaultProtocolHandler = this.protocolHandlers.values().iterator().next();
        } else {
            this.defaultProtocolHandler = defaultProtocolHandler;
            if (this.protocolHandlers.isEmpty() && this.defaultProtocolHandler != null) {
                List protocols = this.defaultProtocolHandler.getSupportedProtocols();
                this.populateProtocolsForHandler(this.defaultProtocolHandler, protocols);
            }
        }
    }

    private void configureProtocolHandlers(List<SubProtocolHandler> protocolHandlers) {
        if (!CollectionUtils.isEmpty(protocolHandlers)) {
            for (SubProtocolHandler handler : protocolHandlers) {
                List protocols = handler.getSupportedProtocols();
                if (CollectionUtils.isEmpty((Collection)protocols)) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn((Object)("No sub-protocols, ignoring handler " + handler));
                    continue;
                }
                this.populateProtocolsForHandler(handler, protocols);
            }
        }
    }

    private void populateProtocolsForHandler(SubProtocolHandler handler, List<String> protocols) {
        for (String protocol : protocols) {
            SubProtocolHandler replaced = this.protocolHandlers.put(protocol, handler);
            if (replaced == null) continue;
            throw new IllegalStateException("Failed to map handler " + handler + " to protocol '" + protocol + "', it is already mapped to handler " + replaced);
        }
    }

    public SubProtocolHandler findProtocolHandler(WebSocketSession session) {
        SubProtocolHandler handler;
        String protocol = session.getAcceptedProtocol();
        if (StringUtils.hasText((String)protocol)) {
            handler = this.protocolHandlers.get(protocol);
            Assert.state((handler != null ? 1 : 0) != 0, () -> "No handler for sub-protocol '" + protocol + "', handlers = " + this.protocolHandlers);
        } else {
            handler = this.defaultProtocolHandler;
            Assert.state((handler != null ? 1 : 0) != 0, (String)"No sub-protocol was requested and a default sub-protocol handler was not configured");
        }
        return handler;
    }

    public String resolveSessionId(Message<?> message) {
        String sessionId;
        for (SubProtocolHandler handler : this.protocolHandlers.values()) {
            String sessionId2 = handler.resolveSessionId(message);
            if (sessionId2 == null) continue;
            return sessionId2;
        }
        if (this.defaultProtocolHandler != null && (sessionId = this.defaultProtocolHandler.resolveSessionId(message)) != null) {
            return sessionId;
        }
        return null;
    }

    public List<String> getSubProtocols() {
        return new ArrayList<String>(this.protocolHandlers.keySet());
    }
}

