/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.webflux.dsl;

import java.net.URI;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.http.dsl.BaseHttpMessageHandlerSpec;
import org.springframework.integration.http.outbound.AbstractHttpRequestExecutingMessageHandler;
import org.springframework.integration.webflux.outbound.WebFluxRequestExecutingMessageHandler;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.client.WebClient;

public class WebFluxMessageHandlerSpec
extends BaseHttpMessageHandlerSpec<WebFluxMessageHandlerSpec, WebFluxRequestExecutingMessageHandler> {
    @Nullable
    protected final WebClient webClient;

    protected WebFluxMessageHandlerSpec(URI uri, @Nullable WebClient webClient) {
        this((Expression)new ValueExpression((Object)uri), webClient);
    }

    protected WebFluxMessageHandlerSpec(String uri, @Nullable WebClient webClient) {
        this((Expression)new LiteralExpression(uri), webClient);
    }

    protected WebFluxMessageHandlerSpec(Expression uriExpression, @Nullable WebClient webClient) {
        super((AbstractHttpRequestExecutingMessageHandler)new WebFluxRequestExecutingMessageHandler(uriExpression, webClient));
        this.webClient = webClient;
    }

    public WebFluxMessageHandlerSpec replyPayloadToFlux(boolean replyPayloadToFlux) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setReplyPayloadToFlux(replyPayloadToFlux);
        return this;
    }

    public WebFluxMessageHandlerSpec bodyExtractor(BodyExtractor<?, ? super ClientHttpResponse> bodyExtractor) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setBodyExtractor(bodyExtractor);
        return this;
    }

    public WebFluxMessageHandlerSpec publisherElementType(Class<?> publisherElementType) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setPublisherElementType(publisherElementType);
        return this;
    }

    public WebFluxMessageHandlerSpec publisherElementType(ParameterizedTypeReference<?> publisherElementType) {
        return this.publisherElementTypeExpression((Expression)new ValueExpression(publisherElementType));
    }

    public <P> WebFluxMessageHandlerSpec publisherElementTypeFunction(Function<Message<P>, ?> typeFunction) {
        return this.publisherElementTypeExpression((Expression)new FunctionExpression(typeFunction));
    }

    public WebFluxMessageHandlerSpec publisherElementTypeExpression(Expression publisherElementTypeExpression) {
        ((WebFluxRequestExecutingMessageHandler)((Object)this.target)).setPublisherElementTypeExpression(publisherElementTypeExpression);
        return this;
    }

    protected boolean isClientSet() {
        return this.webClient != null;
    }

    protected WebFluxMessageHandlerSpec expectReply(boolean expectReply) {
        return (WebFluxMessageHandlerSpec)super.expectReply(expectReply);
    }
}

