/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream.outbound;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class CharacterStreamWritingMessageHandler
extends AbstractMessageHandler {
    private final BufferedWriter writer;
    private volatile boolean shouldAppendNewLine = false;

    public CharacterStreamWritingMessageHandler(Writer writer) {
        this(writer, -1);
    }

    public CharacterStreamWritingMessageHandler(Writer writer, int bufferSize) {
        BufferedWriter bufferedWriter;
        Assert.notNull((Object)writer, (String)"writer must not be null");
        this.writer = writer instanceof BufferedWriter ? (bufferedWriter = (BufferedWriter)writer) : (bufferSize > 0 ? new BufferedWriter(writer, bufferSize) : new BufferedWriter(writer));
    }

    public void setShouldAppendNewLine(boolean shouldAppendNewLine) {
        this.shouldAppendNewLine = shouldAppendNewLine;
    }

    public CharacterStreamWritingMessageHandler appendNewLine(boolean append) {
        this.setShouldAppendNewLine(append);
        return this;
    }

    public String getComponentType() {
        return "stream:outbound-channel-adapter(character)";
    }

    protected void handleMessageInternal(Message<?> message) {
        Object payload = message.getPayload();
        try {
            if (payload instanceof String) {
                String string = (String)payload;
                this.writer.write(string);
            } else if (payload instanceof char[]) {
                char[] chars = (char[])payload;
                this.writer.write(chars);
            } else if (payload instanceof byte[]) {
                byte[] bytes = (byte[])payload;
                this.writer.write(new String(bytes));
            } else if (payload instanceof Exception) {
                Exception exception = (Exception)payload;
                PrintWriter printWriter = new PrintWriter((Writer)this.writer, true);
                exception.printStackTrace(printWriter);
            } else {
                this.writer.write(payload.toString());
            }
            if (this.shouldAppendNewLine) {
                this.writer.newLine();
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in target", (Throwable)e);
        }
    }

    public static CharacterStreamWritingMessageHandler stdout() {
        return CharacterStreamWritingMessageHandler.stdout(null);
    }

    public static CharacterStreamWritingMessageHandler stdout(@Nullable String charsetName) {
        return CharacterStreamWritingMessageHandler.createTargetForStream(System.out, charsetName);
    }

    public static CharacterStreamWritingMessageHandler stderr() {
        return CharacterStreamWritingMessageHandler.stderr(null);
    }

    public static CharacterStreamWritingMessageHandler stderr(@Nullable String charsetName) {
        return CharacterStreamWritingMessageHandler.createTargetForStream(System.err, charsetName);
    }

    private static CharacterStreamWritingMessageHandler createTargetForStream(OutputStream stream, @Nullable String charsetName) {
        if (charsetName == null) {
            return new CharacterStreamWritingMessageHandler(new OutputStreamWriter(stream));
        }
        try {
            return new CharacterStreamWritingMessageHandler(new OutputStreamWriter(stream, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: " + charsetName, e);
        }
    }
}

