/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.messaging.MessagingException;

public class ByteStreamReadingMessageSource
extends AbstractMessageSource<byte[]> {
    private final Lock lock = new ReentrantLock();
    private final BufferedInputStream stream;
    private int bytesPerMessage = 1024;
    private boolean shouldTruncate = true;

    public ByteStreamReadingMessageSource(InputStream stream) {
        this(stream, -1);
    }

    public ByteStreamReadingMessageSource(InputStream stream, int bufferSize) {
        BufferedInputStream bufferedInputStream;
        this.stream = stream instanceof BufferedInputStream ? (bufferedInputStream = (BufferedInputStream)stream) : (bufferSize > 0 ? new BufferedInputStream(stream, bufferSize) : new BufferedInputStream(stream));
    }

    public void setBytesPerMessage(int bytesPerMessage) {
        this.bytesPerMessage = bytesPerMessage;
    }

    public void setShouldTruncate(boolean shouldTruncate) {
        this.shouldTruncate = shouldTruncate;
    }

    public String getComponentType() {
        return "stream:stdin-channel-adapter(byte)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte @Nullable [] doReceive() {
        try {
            byte[] bytes;
            int bytesRead = 0;
            this.lock.lock();
            try {
                if (this.stream.available() == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                bytes = new byte[this.bytesPerMessage];
                bytesRead = this.stream.read(bytes, 0, bytes.length);
            }
            finally {
                this.lock.unlock();
            }
            if (bytesRead <= 0) {
                return null;
            }
            if (!this.shouldTruncate) {
                return bytes;
            }
            byte[] result = new byte[bytesRead];
            System.arraycopy(bytes, 0, result, 0, result.length);
            return result;
        }
        catch (IOException e) {
            throw new MessagingException("IO failure occurred in adapter", (Throwable)e);
        }
    }
}

