/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.server;

import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.sftp.server.DirectoryCreatedEvent;
import org.springframework.integration.sftp.server.FileWrittenEvent;
import org.springframework.integration.sftp.server.PathMovedEvent;
import org.springframework.integration.sftp.server.PathRemovedEvent;
import org.springframework.integration.sftp.server.SessionClosedEvent;
import org.springframework.integration.sftp.server.SessionOpenedEvent;
import org.springframework.util.Assert;

public class ApacheMinaSftpEventListener
implements SftpEventListener,
ApplicationEventPublisherAware,
BeanNameAware,
InitializingBean {
    private ApplicationEventPublisher applicationEventPublisher;
    private @Nullable String beanName;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public @Nullable String getBeanName() {
        return this.beanName;
    }

    public void afterPropertiesSet() {
        Assert.state((this.applicationEventPublisher != null ? 1 : 0) != 0, (String)"An ApplicationEventPublisher is required");
    }

    public void initialized(ServerSession session, int version) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SessionOpenedEvent(session, version));
    }

    public void destroying(ServerSession session) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SessionClosedEvent(session));
    }

    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DirectoryCreatedEvent(session, path, attrs));
    }

    public void removed(ServerSession session, Path path, boolean isDirectory, Throwable thrown) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PathRemovedEvent(session, path, isDirectory, thrown));
    }

    public void written(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, Throwable thrown) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new FileWrittenEvent(session, remoteHandle, localHandle.getFile(), dataLen, thrown));
    }

    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new PathMovedEvent(session, srcPath, dstPath, thrown));
    }

    public String toString() {
        return "ApacheMinaSftpEventListener [beanName=" + this.beanName + "]";
    }
}

