/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JschProxyFactoryBean
extends AbstractFactoryBean<Proxy> {
    private final Type type;
    private final String host;
    private final int port;
    private final String user;
    private final String password;

    public JschProxyFactoryBean(Type type, String host, int port, String user, String password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
    }

    public Class<?> getObjectType() {
        switch (this.type) {
            case SOCKS5: {
                return ProxySOCKS5.class;
            }
            case SOCKS4: {
                return ProxySOCKS4.class;
            }
            case HTTP: {
                return ProxyHTTP.class;
            }
        }
        throw new IllegalArgumentException("Invalid type:" + (Object)((Object)this.type));
    }

    protected Proxy createInstance() {
        switch (this.type) {
            case SOCKS5: {
                ProxySOCKS5 socks5proxy = new ProxySOCKS5(this.host, this.port);
                socks5proxy.setUserPasswd(this.user, this.password);
                return socks5proxy;
            }
            case SOCKS4: {
                ProxySOCKS4 socks4proxy = new ProxySOCKS4(this.host, this.port);
                socks4proxy.setUserPasswd(this.user, this.password);
                return socks4proxy;
            }
            case HTTP: {
                ProxyHTTP httpProxy = new ProxyHTTP(this.host, this.port);
                httpProxy.setUserPasswd(this.user, this.password);
                return httpProxy;
            }
        }
        throw new IllegalArgumentException("Invalid type:" + (Object)((Object)this.type));
    }

    public static enum Type {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

