/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rsocket;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.integration.rsocket.IntegrationRSocketMessageHandler;
import org.springframework.integration.rsocket.RSocketConnectedEvent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.CompositeMessageCondition;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.annotation.support.RSocketFrameTypeMessageCondition;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ServerRSocketMessageHandler
extends IntegrationRSocketMessageHandler
implements ApplicationEventPublisherAware {
    private static final Method HANDLE_CONNECTION_SETUP_METHOD = ReflectionUtils.findMethod(ServerRSocketMessageHandler.class, (String)"handleConnectionSetup", (Class[])new Class[]{Message.class});
    private final Map<Object, RSocketRequester> clientRSocketRequesters = new HashMap<Object, RSocketRequester>();
    private BiFunction<Map<String, Object>, DataBuffer, Object> clientRSocketKeyStrategy = (headers, data) -> data.toString(StandardCharsets.UTF_8);
    private ApplicationEventPublisher applicationEventPublisher;

    public ServerRSocketMessageHandler() {
        this(false);
    }

    public ServerRSocketMessageHandler(boolean messageMappingCompatible) {
        super(messageMappingCompatible);
    }

    public void setClientRSocketKeyStrategy(BiFunction<Map<String, Object>, DataBuffer, Object> clientRSocketKeyStrategy) {
        Assert.notNull(clientRSocketKeyStrategy, (String)"'clientRSocketKeyStrategy' must not be null");
        this.clientRSocketKeyStrategy = clientRSocketKeyStrategy;
    }

    public Map<Object, RSocketRequester> getClientRSocketRequesters() {
        return Collections.unmodifiableMap(this.clientRSocketRequesters);
    }

    @Nullable
    public RSocketRequester getClientRSocketRequester(Object key) {
        return this.clientRSocketRequesters.get(key);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    void registerHandleConnectionSetupMethod() {
        this.registerHandlerMethod((Object)this, HANDLE_CONNECTION_SETUP_METHOD, new CompositeMessageCondition(new MessageCondition[]{RSocketFrameTypeMessageCondition.CONNECT_CONDITION, new DestinationPatternsMessageCondition(new String[]{"*"}, this.obtainRouteMatcher())}));
    }

    private void handleConnectionSetup(Message<DataBuffer> connectMessage) {
        DataBuffer dataBuffer = (DataBuffer)connectMessage.getPayload();
        MessageHeaders messageHeaders = connectMessage.getHeaders();
        Object rsocketRequesterKey = this.clientRSocketKeyStrategy.apply((Map<String, Object>)messageHeaders, dataBuffer);
        RSocketRequester rsocketRequester = (RSocketRequester)messageHeaders.get((Object)"rsocketRequester", RSocketRequester.class);
        this.clientRSocketRequesters.put(rsocketRequesterKey, rsocketRequester);
        RSocketConnectedEvent rSocketConnectedEvent = new RSocketConnectedEvent((Object)this, (Map<String, Object>)messageHeaders, dataBuffer, rsocketRequester);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)rSocketConnectedEvent);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("The RSocket has been connected: " + (Object)((Object)rSocketConnectedEvent)));
        }
    }
}

