/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi;

import java.io.Serializable;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessagingException;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.rmi.RmiProxyFactoryBean;

public class RmiOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final RequestReplyExchanger proxy;
    private final RmiProxyFactoryBeanConfigurer configurer;

    public RmiOutboundGateway(String url) {
        this(url, null);
    }

    public RmiOutboundGateway(String url, RmiProxyFactoryBeanConfigurer configurer) {
        this.configurer = configurer;
        this.proxy = this.createProxy(url);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        this.setOutputChannel(replyChannel);
    }

    public String getComponentType() {
        return "rmi:outbound-gateway";
    }

    public final Object handleRequestMessage(Message<?> requestMessage) {
        if (!(requestMessage.getPayload() instanceof Serializable)) {
            throw new MessageHandlingException(requestMessage, this.getComponentName() + " expects a Serializable payload type but encountered [" + requestMessage.getPayload().getClass().getName() + "]");
        }
        try {
            return this.proxy.exchange(requestMessage);
        }
        catch (MessagingException e) {
            throw new MessageHandlingException(requestMessage, (Throwable)e);
        }
        catch (RemoteAccessException e) {
            throw new MessageHandlingException(requestMessage, "Remote failure in RmiOutboundGateway: " + this.getComponentName(), (Throwable)e);
        }
    }

    private RequestReplyExchanger createProxy(String url) {
        RmiProxyFactoryBean proxyFactory = new RmiProxyFactoryBean();
        proxyFactory.setServiceInterface(RequestReplyExchanger.class);
        proxyFactory.setServiceUrl(url);
        proxyFactory.setLookupStubOnStartup(false);
        proxyFactory.setRefreshStubOnConnectFailure(true);
        if (this.configurer != null) {
            this.configurer.configure(proxyFactory);
        }
        proxyFactory.afterPropertiesSet();
        return (RequestReplyExchanger)proxyFactory.getObject();
    }

    public static interface RmiProxyFactoryBeanConfigurer {
        public void configure(RmiProxyFactoryBean var1);
    }
}

